/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public NSImage handle;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, int n, int n2) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(n, n2);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Image image, int n) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            device = this.device;
            this.type = image.type;
            NSSize nSSize = image.handle.size();
            int n2 = (int)nSSize.width;
            int n3 = (int)nSSize.height;
            NSBitmapImageRep nSBitmapImageRep = image.getRepresentation();
            long l = nSBitmapImageRep.bytesPerRow();
            this.transparentPixel = image.transparentPixel;
            this.alpha = image.alpha;
            if (image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            long l2 = nSBitmapImageRep.bitmapData();
            long l3 = nSBitmapImageRep.bitmapFormat();
            long l4 = nSBitmapImageRep.bitsPerPixel();
            this.handle = (NSImage)new NSImage().alloc();
            this.handle = this.handle.initWithSize(nSSize);
            NSBitmapImageRep nSBitmapImageRep2 = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            nSBitmapImageRep2 = nSBitmapImageRep2.initWithBitmapDataPlanes(0L, n2, n3, nSBitmapImageRep.bitsPerSample(), nSBitmapImageRep.samplesPerPixel(), nSBitmapImageRep.hasAlpha(), nSBitmapImageRep.isPlanar(), OS.NSDeviceRGBColorSpace, l3, nSBitmapImageRep.bytesPerRow(), l4);
            this.handle.addRepresentation(nSBitmapImageRep2);
            nSBitmapImageRep2.release();
            this.handle.setCacheMode(3L);
            long l5 = nSBitmapImageRep2.bitmapData();
            OS.memmove(l5, l2, (long)(n2 * n3 * 4));
            if (n != 0) {
                int n4;
                int n5;
                int n6;
                if (l4 == 32L && (l3 & 1L) == 0L) {
                    n6 = 0;
                    n5 = 1;
                    n4 = 2;
                } else {
                    n6 = 1;
                    n5 = 2;
                    n4 = 3;
                }
                switch (n) {
                    case 1: {
                        Color color = device.getSystemColor(18);
                        RGB rGB = color.getRGB();
                        byte by = (byte)rGB.red;
                        byte by2 = (byte)rGB.green;
                        byte by3 = (byte)rGB.blue;
                        Color color2 = device.getSystemColor(22);
                        RGB rGB2 = color2.getRGB();
                        byte by4 = (byte)rGB2.red;
                        byte by5 = (byte)rGB2.green;
                        byte by6 = (byte)rGB2.blue;
                        byte[] byArray = new byte[(int)l];
                        for (int i = 0; i < n3; ++i) {
                            OS.memmove(byArray, l5 + (long)i * l, l);
                            int n7 = 0;
                            for (int j = 0; j < n2; ++j) {
                                int n8 = byArray[n7 + n6] & 0xFF;
                                int n9 = byArray[n7 + n5] & 0xFF;
                                int n10 = byArray[n7 + n4] & 0xFF;
                                int n11 = n8 * n8 + n9 * n9 + n10 * n10;
                                if (n11 < 98304) {
                                    byArray[n7 + n6] = by;
                                    byArray[n7 + n5] = by2;
                                    byArray[n7 + n4] = by3;
                                } else {
                                    byArray[n7 + n6] = by4;
                                    byArray[n7 + n5] = by5;
                                    byArray[n7 + n4] = by6;
                                }
                                n7 += 4;
                            }
                            OS.memmove(l5 + (long)i * l, byArray, l);
                        }
                        break;
                    }
                    case 2: {
                        byte[] byArray = new byte[(int)l];
                        for (int i = 0; i < n3; ++i) {
                            OS.memmove(byArray, l5 + (long)i * l, l);
                            int n12 = 0;
                            for (int j = 0; j < n2; ++j) {
                                byte by;
                                int n13 = byArray[n12 + n6] & 0xFF;
                                int n14 = byArray[n12 + n5] & 0xFF;
                                int n15 = byArray[n12 + n4] & 0xFF;
                                byte by7 = by = (byte)(n13 + n13 + n14 + n14 + n14 + n14 + n14 + n15 >> 3);
                                byArray[n12 + n4] = by7;
                                byArray[n12 + n5] = by7;
                                byArray[n12 + n6] = by7;
                                n12 += 4;
                            }
                            OS.memmove(l5 + (long)i * l, byArray, l);
                        }
                        break;
                    }
                }
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(rectangle.width, rectangle.height);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData imageData) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(imageData);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            imageData2 = ImageData.convertMask(imageData2);
            ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
            imageData3.maskPad = imageData2.scanlinePad;
            imageData3.maskData = imageData2.data;
            this.init(imageData3);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, InputStream inputStream) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(new ImageData(inputStream));
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, String string) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (string == null) {
                SWT.error(4);
            }
            this.initNative(string);
            if (this.handle == null) {
                this.init(new ImageData(string));
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAlpha() {
        if (this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            long l = nSBitmapImageRep.pixelsHigh();
            long l2 = nSBitmapImageRep.bytesPerRow();
            long l3 = nSBitmapImageRep.bitmapData();
            long l4 = nSBitmapImageRep.bitmapFormat();
            long l5 = l * l2;
            byte[] byArray = new byte[(int)l5];
            OS.memmove(byArray, l3, l5);
            if (this.transparentPixel != -1) {
                if ((l4 & 1L) != 0L) {
                    int n = 0;
                    while ((long)n < l5) {
                        int n2 = (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
                        byArray[n] = (byte)(n2 == this.transparentPixel ? 0 : 255);
                        n += 4;
                    }
                } else {
                    int n = 0;
                    while ((long)n < l5) {
                        int n3 = (byArray[n + 0] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
                        byArray[n] = (byte)(n3 == this.transparentPixel ? 0 : 255);
                        n += 4;
                    }
                }
            } else if (this.alpha != -1) {
                int n;
                byte by = (byte)this.alpha;
                int n4 = n = (l4 & 1L) != 0L ? 0 : 3;
                while ((long)n < l5) {
                    byArray[n] = by;
                    n += 4;
                }
            } else {
                long l6 = nSBitmapImageRep.pixelsWide();
                int n = 0;
                int n5 = (l4 & 1L) != 0L ? 0 : 3;
                int n6 = 0;
                while ((long)n6 < l) {
                    int n7 = 0;
                    while ((long)n7 < l6) {
                        byArray[n] = this.alphaData[n5];
                        n += 4;
                        ++n5;
                        ++n7;
                    }
                    ++n6;
                }
            }
            nSBitmapImageRep.setAlpha(true);
            OS.memmove(l3, byArray, l5);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        this.handle.release();
        this.handle = null;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle && this.transparentPixel == image.transparentPixel;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int n = this.transparentPixel >> 16 & 0xFF;
        int n2 = this.transparentPixel >> 8 & 0xFF;
        int n3 = this.transparentPixel >> 0 & 0xFF;
        return Color.cocoa_new(this.device, new double[]{(float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.width != -1 && this.height != -1) {
                Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
                return rectangle;
            }
            NSSize nSSize = this.handle.size();
            this.width = (int)nSSize.width;
            this.height = (int)nSSize.height;
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n;
            Object object;
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            long l = nSBitmapImageRep.pixelsWide();
            long l2 = nSBitmapImageRep.pixelsHigh();
            long l3 = nSBitmapImageRep.bytesPerRow();
            long l4 = nSBitmapImageRep.bitsPerPixel();
            long l5 = nSBitmapImageRep.bitmapData();
            long l6 = nSBitmapImageRep.bitmapFormat();
            long l7 = l2 * l3;
            byte[] byArray = new byte[(int)l7];
            OS.memmove(byArray, l5, l7);
            PaletteData paletteData = l4 == 32L && (l6 & 1L) == 0L ? new PaletteData(-16777216, 0xFF0000, 65280) : new PaletteData(0xFF0000, 65280, 255);
            ImageData imageData = new ImageData((int)l, (int)l2, (int)l4, paletteData, 1, byArray);
            imageData.bytesPerLine = (int)l3;
            if (nSBitmapImageRep.hasAlpha() && this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
                object = new byte[(int)(l * l2)];
                n = (l6 & 1L) != 0L ? 0 : 3;
                int n2 = 0;
                for (int i = n; i < byArray.length; i += 4) {
                    object[n2++] = byArray[i];
                }
                imageData.alphaData = object;
            } else {
                imageData.transparentPixel = this.transparentPixel;
                if (this.transparentPixel == -1 && this.type == 1) {
                    int n3 = 2;
                    long l8 = ((l + 7L) / 8L + (long)(n3 - 1)) / (long)n3 * (long)n3;
                    byte[] byArray2 = new byte[(int)(l2 * l8)];
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    while ((long)n6 < l2) {
                        int n7 = 0;
                        while ((long)n7 < l) {
                            if (byArray[n4] != 0) {
                                int n8 = n5 + (n7 >> 3);
                                byArray2[n8] = (byte)(byArray2[n8] | 1 << 7 - (n7 & 7));
                            } else {
                                int n9 = n5 + (n7 >> 3);
                                byArray2[n9] = (byte)(byArray2[n9] & ~(1 << 7 - (n7 & 7)));
                            }
                            n4 += 4;
                            ++n7;
                        }
                        n5 = (int)((long)n5 + l8);
                        ++n6;
                    }
                    imageData.maskData = byArray2;
                    imageData.maskPad = n3;
                }
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
            }
            if (l4 == 32L) {
                int n10;
                for (n = n10 = (l6 & 1L) != 0L ? 0 : 3; n < byArray.length; n += 4) {
                    byArray[n] = 0;
                }
            }
            object = imageData;
            return object;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public static Image cocoa_new(Device device, int n, NSImage nSImage) {
        Image image = new Image(device);
        image.type = n;
        image.handle = nSImage;
        return image;
    }

    NSBitmapImageRep getRepresentation() {
        NSBitmapImageRep nSBitmapImageRep = new NSBitmapImageRep(this.handle.bestRepresentationForDevice(null));
        if (nSBitmapImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
            return nSBitmapImageRep;
        }
        NSArray nSArray = this.handle.representations();
        NSSize nSSize = this.handle.size();
        long l = nSArray.count();
        NSObject nSObject = null;
        int n = 0;
        while ((long)n < l) {
            nSBitmapImageRep = new NSBitmapImageRep(nSArray.objectAtIndex(n));
            if (nSBitmapImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return nSBitmapImageRep;
            }
            if (nSObject == null || (long)((int)nSSize.width) == nSBitmapImageRep.pixelsWide() && (long)((int)nSSize.height) == nSBitmapImageRep.pixelsHigh()) {
                nSObject = nSBitmapImageRep;
            }
            ++n;
        }
        nSObject.retain();
        n = 0;
        while ((long)n < l) {
            this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0L)));
            ++n;
        }
        this.handle.addRepresentation((NSImageRep)nSObject);
        NSBitmapImageRep nSBitmapImageRep2 = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep2 = nSBitmapImageRep2.initWithData(this.handle.TIFFRepresentation());
        this.handle.addRepresentation(nSBitmapImageRep2);
        this.handle.removeRepresentation((NSImageRep)nSObject);
        nSObject.release();
        nSBitmapImageRep2.release();
        return nSBitmapImageRep2;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.width = n;
        this.height = n2;
        this.handle = (NSImage)new NSImage().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = n;
        nSSize.height = n2;
        this.handle = this.handle.initWithSize(nSSize);
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, n, n2, 8L, 3L, false, false, OS.NSDeviceRGBColorSpace, 3L, n * 4, 32L);
        OS.memset(nSBitmapImageRep.bitmapData(), 255, n * n2 * 4);
        this.handle.addRepresentation(nSBitmapImageRep);
        nSBitmapImageRep.release();
        this.handle.setCacheMode(3L);
    }

    void init(ImageData imageData) {
        RGB rGB;
        int n;
        byte[] byArray;
        Object object;
        boolean bl;
        if (imageData == null) {
            SWT.error(4);
        }
        this.width = imageData.width;
        this.height = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        int n2 = this.width * this.height * 4;
        int n3 = this.width * 4;
        byte[] byArray2 = new byte[n2];
        if (paletteData.isDirect) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, this.width, this.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray2, 32, n3, 1, 0, 0, this.width, this.height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rGBArray = paletteData.getRGBs();
            bl = rGBArray.length;
            object = new byte[bl];
            byArray = new byte[bl];
            byte[] byArray3 = new byte[bl];
            for (n = 0; n < rGBArray.length; ++n) {
                rGB = rGBArray[n];
                if (rGB == null) continue;
                object[n] = (byte)rGB.red;
                byArray[n] = (byte)rGB.green;
                byArray3[n] = (byte)rGB.blue;
            }
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, this.width, this.height, object, byArray, byArray3, 255, null, 0, 0, 0, byArray2, 32, n3, 1, 0, 0, this.width, this.height, 0xFF0000, 65280, 255, false, false);
        }
        int n4 = imageData.getTransparencyType();
        boolean bl2 = bl = n4 != 0;
        if (n4 == 2 || imageData.transparentPixel != -1) {
            int n5 = this.type = imageData.transparentPixel != -1 ? 0 : 1;
            if (imageData.transparentPixel != -1) {
                Object object2;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                if (paletteData.isDirect) {
                    object2 = paletteData.getRGB(imageData.transparentPixel);
                    n6 = object2.red;
                    n7 = object2.green;
                    n8 = object2.blue;
                } else {
                    object2 = paletteData.getRGBs();
                    if (imageData.transparentPixel < ((RGB[])object2).length) {
                        rGB = object2[imageData.transparentPixel];
                        n6 = rGB.red;
                        n7 = rGB.green;
                        n8 = rGB.blue;
                    }
                }
                this.transparentPixel = n6 << 16 | n7 << 8 | n8;
            }
            object = imageData.getTransparencyMask();
            byArray = object.data;
            int n9 = object.bytesPerLine;
            n = 0;
            int n10 = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    byArray2[n] = (byArray[n10 + (j >> 3)] & 1 << 7 - (j & 7)) != 0 ? -1 : 0;
                    n += 4;
                }
                n10 += n9;
            }
        } else {
            this.type = 0;
            if (imageData.alpha != -1) {
                bl = true;
                this.alpha = imageData.alpha;
                byte by = (byte)this.alpha;
                for (int i = 0; i < byArray2.length; i += 4) {
                    byArray2[i] = by;
                }
            } else if (imageData.alphaData != null) {
                bl = true;
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                int n11 = 0;
                int n12 = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (n = 0; n < this.width; ++n) {
                        byArray2[n11] = this.alphaData[n12];
                        n11 += 4;
                        ++n12;
                    }
                }
            }
        }
        if (this.handle != null) {
            this.handle.release();
        }
        this.handle = (NSImage)new NSImage().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = this.width;
        nSSize.height = this.height;
        this.handle = this.handle.initWithSize(nSSize);
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, this.width, this.height, 8L, bl ? 4L : 3L, bl, false, OS.NSDeviceRGBColorSpace, 3L, n3, 32L);
        OS.memmove(nSBitmapImageRep.bitmapData(), byArray2, (long)n2);
        this.handle.addRepresentation(nSBitmapImageRep);
        nSBitmapImageRep.release();
        this.handle.setCacheMode(3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNative(String string) {
        NSAutoreleasePool nSAutoreleasePool = null;
        NSImage nSImage = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            nSImage = new NSImage();
            nSImage.alloc();
            nSImage = nSImage.initWithContentsOfFile(NSString.stringWith(string));
            if (nSImage == null) {
                return;
            }
            NSImageRep nSImageRep = nSImage.bestRepresentationForDevice(null);
            if (!nSImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return;
            }
            this.width = (int)nSImageRep.pixelsWide();
            this.height = (int)nSImageRep.pixelsHigh();
            boolean bl = nSImageRep.hasAlpha();
            int n = this.width * 4;
            this.handle = (NSImage)new NSImage().alloc();
            NSSize nSSize = new NSSize();
            nSSize.width = this.width;
            nSSize.height = this.height;
            this.handle = this.handle.initWithSize(nSSize);
            NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, this.width, this.height, 8L, bl ? 4L : 3L, bl, false, OS.NSDeviceRGBColorSpace, 3L, n, 32L);
            this.handle.addRepresentation(nSBitmapImageRep);
            nSBitmapImageRep.release();
            this.handle.setCacheMode(3L);
            NSRect nSRect = new NSRect();
            nSRect.width = this.width;
            nSRect.height = this.height;
            long l = OS.CGColorSpaceCreateDeviceRGB();
            long l2 = OS.CGBitmapContextCreate(nSBitmapImageRep.bitmapData(), this.width, this.height, 8L, n, l, 6);
            OS.CGColorSpaceRelease(l);
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(l2, false));
            nSImageRep.drawInRect(nSRect);
            NSGraphicsContext.static_restoreGraphicsState();
            OS.CGContextRelease(l2);
            if (bl) {
                long l3 = this.width;
                long l4 = l3 * (long)this.height;
                long l5 = OS.malloc(l4);
                long l6 = OS.CGBitmapContextCreate(l5, this.width, this.height, 8L, l3, 0L, 7);
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(l6, false));
                nSImageRep.drawInRect(nSRect);
                NSGraphicsContext.static_restoreGraphicsState();
                byte[] byArray = new byte[(int)l4];
                OS.memmove(byArray, l5, l4);
                OS.free(l5);
                OS.CGContextRelease(l6);
                byte[] byArray2 = new byte[this.height * n];
                OS.memmove(byArray2, nSBitmapImageRep.bitmapData(), (long)byArray2.length);
                int n2 = 0;
                int n3 = 0;
                while (n2 < byArray.length) {
                    byArray2[n3] = byArray[n2];
                    float f = byArray[n2] & 0xFF;
                    if (f != 0.0f) {
                        byArray2[n3 + 1] = (byte)((float)(byArray2[n3 + 1] & 0xFF) / f * 255.0f);
                        byArray2[n3 + 2] = (byte)((float)(byArray2[n3 + 2] & 0xFF) / f * 255.0f);
                        byArray2[n3 + 3] = (byte)((float)(byArray2[n3 + 3] & 0xFF) / f * 255.0f);
                    }
                    ++n2;
                    n3 += 4;
                }
                OS.memmove(nSBitmapImageRep.bitmapData(), byArray2, (long)byArray2.length);
                n2 = -1;
                n3 = 0;
                for (n3 = 0; n3 < byArray.length; ++n3) {
                    byte by = byArray[n3];
                    if (n2 == -1 && by == 0) {
                        n2 = n3;
                    }
                    if (by != 0 && by != -1) break;
                }
                this.alpha = -1;
                if (n3 == byArray.length && n2 != -1) {
                    NSColor nSColor = nSBitmapImageRep.colorAtX(n2 % this.width, n2 / this.width);
                    int n4 = (int)(nSColor.redComponent() * 255.0);
                    int n5 = (int)(nSColor.greenComponent() * 255.0);
                    int n6 = (int)(nSColor.blueComponent() * 255.0);
                    this.transparentPixel = n4 << 16 | n5 << 8 | n6;
                    for (int i = 0; i < byArray2.length; i += 4) {
                        int n7;
                        if (byArray2[i] == 0 || (n7 = (byArray2[i + 1] & 0xFF) << 16 | (byArray2[i + 2] & 0xFF) << 8 | byArray2[i + 3] & 0xFF) != this.transparentPixel) continue;
                        this.transparentPixel = -1;
                        break;
                    }
                }
                if (this.transparentPixel == -1) {
                    this.alphaData = byArray;
                }
            }
            this.type = string.toLowerCase().endsWith(".ico") ? 1 : 0;
        }
        finally {
            if (nSImage != null) {
                nSImage.release();
            }
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long internal_new_GC(GCData gCData) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSGraphicsContext nSGraphicsContext;
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            nSBitmapImageRep.setAlpha(false);
            NSGraphicsContext nSGraphicsContext2 = NSGraphicsContext.graphicsContextWithBitmapImageRep(nSBitmapImageRep);
            nSGraphicsContext2 = nSGraphicsContext = NSGraphicsContext.graphicsContextWithGraphicsPort(nSGraphicsContext2.graphicsPort(), true);
            nSGraphicsContext2.retain();
            if (gCData != null) {
                gCData.flippedContext = nSGraphicsContext;
            }
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(nSGraphicsContext2);
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            NSSize nSSize = this.handle.size();
            nSAffineTransform.translateXBy(0.0, nSSize.height);
            nSAffineTransform.scaleXBy(1.0, -1.0);
            nSAffineTransform.set();
            NSGraphicsContext.static_restoreGraphicsState();
            if (gCData != null) {
                int n = 0x6000000;
                if ((gCData.style & n) == 0) {
                    gCData.style |= 0x2000000;
                }
                gCData.device = this.device;
                gCData.background = this.device.COLOR_WHITE.handle;
                gCData.foreground = this.device.COLOR_BLACK.handle;
                gCData.font = this.device.systemFont;
                gCData.image = this;
            }
            long l = nSGraphicsContext2.id;
            return l;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_dispose_GC(long l, GCData gCData) {
        long l2 = l;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (l2 != 0L) {
                NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
                nSBitmapImageRep.bitmapData();
                NSGraphicsContext nSGraphicsContext = new NSGraphicsContext(l2);
                nSGraphicsContext.release();
            }
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n;
            int n2;
            int n3;
            byte by = (byte)(this.transparentPixel >> 16 & 0xFF);
            byte by2 = (byte)(this.transparentPixel >> 8 & 0xFF);
            byte by3 = (byte)(this.transparentPixel >> 0 & 0xFF);
            byte by4 = (byte)((int)(color.handle[0] * 255.0) & 0xFF);
            byte by5 = (byte)((int)(color.handle[1] * 255.0) & 0xFF);
            byte by6 = (byte)((int)(color.handle[2] * 255.0) & 0xFF);
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            long l = nSBitmapImageRep.bytesPerRow();
            long l2 = nSBitmapImageRep.bitmapData();
            long l3 = nSBitmapImageRep.bitmapFormat();
            long l4 = nSBitmapImageRep.bitsPerPixel();
            if (l4 == 32L && (l3 & 1L) == 0L) {
                n3 = 0;
                n2 = 1;
                n = 2;
            } else {
                n3 = 1;
                n2 = 2;
                n = 3;
            }
            byte[] byArray = new byte[(int)l];
            int n4 = 0;
            for (int i = 0; i < this.height; ++i) {
                OS.memmove(byArray, l2 + (long)n4, l);
                for (int j = 0; j < byArray.length; j += 4) {
                    if (byArray[j + n3] != by || byArray[j + n2] != by2 || byArray[j + n] != by3) continue;
                    byArray[j + n3] = by4;
                    byArray[j + n2] = by5;
                    byArray[j + n] = by6;
                }
                OS.memmove(l2 + (long)n4, byArray, l);
                n4 = (int)((long)n4 + l);
            }
            this.transparentPixel = (by4 & 0xFF) << 16 | (by5 & 0xFF) << 8 | by6 & 0xFF;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }
}

