/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSInputManager;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPanel;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSet;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTouch;
import org.eclipse.swt.internal.cocoa.NSTrackingArea;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Touch;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public NSView view;
    Composite parent;
    String toolTipText;
    Object layoutData;
    int drawCount;
    Menu menu;
    double[] foreground;
    double[] background;
    Image backgroundImage;
    Font font;
    Cursor cursor;
    Region region;
    NSBezierPath regionPath;
    long visibleRgn;
    Accessible accessible;
    boolean touchEnabled;
    static final int CLIPPING = 1024;
    static final int VISIBLE_REGION = 4096;
    static final int DEFAULT_DRAG_HYSTERESIS = 5;
    static final double SYNTHETIC_BOLD = -2.5;
    static final double SYNTHETIC_ITALIC = 0.2;

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget();
    }

    boolean acceptsFirstMouse(long l, long l2, long l3) {
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0) {
            return true;
        }
        return super.acceptsFirstMouse(l, l2, l3);
    }

    long accessibleHandle() {
        long l = this.view.id;
        if (this.view instanceof NSControl && ((NSControl)this.view).cell() != null) {
            l = ((NSControl)this.view).cell().id;
        }
        return l;
    }

    long accessibilityActionDescription(long l, long l2, long l3) {
        NSString nSString;
        id id2;
        if (l == this.accessibleHandle() && this.accessible != null && (id2 = this.accessible.internal_accessibilityActionDescription(nSString = new NSString(l3), -1)) != null) {
            return id2.id;
        }
        return super.accessibilityActionDescription(l, l2, l3);
    }

    long accessibilityActionNames(long l, long l2) {
        long l3 = super.accessibilityActionNames(l, l2);
        if (this.handleIsAccessible(l)) {
            NSArray nSArray;
            if (this.accessible != null && (nSArray = this.accessible.internal_accessibilityActionNames(-1)) != null) {
                l3 = nSArray.id;
            }
            if (this.hooks(35) || this.menu != null && !this.menu.isDisposed()) {
                nSArray = new NSArray(l3);
                NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() + 1L);
                nSMutableArray.addObjectsFromArray(nSArray);
                nSMutableArray.addObject(OS.NSAccessibilityShowMenuAction);
                l3 = nSMutableArray.id;
            }
        }
        return l3;
    }

    long accessibilityAttributeNames(long l, long l2) {
        long l3 = 0L;
        if (this.handleIsAccessible(l) && this.accessible != null) {
            NSArray nSArray = this.accessible.internal_accessibilityAttributeNames(-1);
            long l4 = l3 = nSArray != null ? nSArray.id : 0L;
            if (l3 == 0L) {
                l3 = super.accessibilityAttributeNames(l, l2);
            }
            l3 = this.accessible.internal_addRelationAttributes(l3);
        }
        if (l3 == 0L) {
            l3 = super.accessibilityAttributeNames(l, l2);
        }
        return l3;
    }

    boolean handleIsAccessible(long l) {
        return l == this.accessibleHandle();
    }

    long accessibilityParameterizedAttributeNames(long l, long l2) {
        NSArray nSArray;
        if (this.handleIsAccessible(l) && this.accessible != null && (nSArray = this.accessible.internal_accessibilityParameterizedAttributeNames(-1)) != null) {
            return nSArray.id;
        }
        return super.accessibilityParameterizedAttributeNames(l, l2);
    }

    void accessibilityPerformAction(long l, long l2, long l3) {
        NSString nSString;
        if (this.handleIsAccessible(l) && this.accessible != null && this.accessible.internal_accessibilityPerformAction(nSString = new NSString(l3), -1)) {
            return;
        }
        super.accessibilityPerformAction(l, l2, l3);
    }

    long accessibilityFocusedUIElement(long l, long l2) {
        id id2 = null;
        if (this.handleIsAccessible(l) && this.accessible != null) {
            id2 = this.accessible.internal_accessibilityFocusedUIElement(-1);
        }
        if (id2 == null) {
            return super.accessibilityFocusedUIElement(l, l2);
        }
        return id2.id;
    }

    long accessibilityHitTest(long l, long l2, NSPoint nSPoint) {
        id id2 = null;
        if (this.handleIsAccessible(l) && this.accessible != null) {
            id2 = this.accessible.internal_accessibilityHitTest(nSPoint, -1);
        }
        if (id2 == null) {
            return super.accessibilityHitTest(l, l2, nSPoint);
        }
        return id2.id;
    }

    long accessibilityAttributeValue(long l, long l2, long l3) {
        NSString nSString = new NSString(l3);
        long l4 = 0L;
        id id2 = null;
        if (this.handleIsAccessible(l) && this.accessible != null) {
            id2 = this.accessible.internal_accessibilityAttributeValue(nSString, -1);
        }
        if (id2 == null) {
            l4 = super.accessibilityAttributeValue(l, l2, l3);
            if (id2 == null && nSString.isEqualToString(OS.NSAccessibilityHelpAttribute) && this.toolTipText != null) {
                l4 = NSString.stringWith((String)this.toolTipText).id;
            }
        } else {
            l4 = id2.id;
        }
        return l4;
    }

    long accessibilityAttributeValue_forParameter(long l, long l2, long l3, long l4) {
        NSString nSString = new NSString(l3);
        id id2 = null;
        if (this.handleIsAccessible(l) && this.accessible != null) {
            id id3 = new id(l4);
            id2 = this.accessible.internal_accessibilityAttributeValue_forParameter(nSString, id3, -1);
        }
        if (id2 == null) {
            return super.accessibilityAttributeValue_forParameter(l, l2, l3, l4);
        }
        return id2.id;
    }

    boolean accessibilityIsAttributeSettable(long l, long l2, long l3) {
        boolean bl = false;
        if (this.handleIsAccessible(l) && this.accessible != null) {
            NSString nSString = new NSString(l3);
            bl = this.accessible.internal_accessibilityIsAttributeSettable(nSString, -1);
        }
        if (!bl) {
            bl = super.accessibilityIsAttributeSettable(l, l2, l3);
        }
        return bl;
    }

    void accessibilitySetValue_forAttribute(long l, long l2, long l3, long l4) {
        if (this.handleIsAccessible(l) && this.accessible != null) {
            id id2 = new id(l3);
            NSString nSString = new NSString(l4);
            this.accessible.internal_accessibilitySetValue_forAttribute(id2, nSString, -1);
        } else {
            super.accessibilitySetValue_forAttribute(l, l2, l3, l4);
        }
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(gestureListener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    void addTraits(NSMutableDictionary nSMutableDictionary, Font font) {
        if ((font.extraTraits & 2) != 0) {
            nSMutableDictionary.setObject(NSNumber.numberWithDouble(-2.5), OS.NSStrokeWidthAttributeName);
        }
        if ((font.extraTraits & 1) != 0) {
            nSMutableDictionary.setObject(NSNumber.numberWithDouble(0.2), OS.NSObliquenessAttributeName);
        }
    }

    public void addTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(touchListener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    boolean becomeFirstResponder(long l, long l2) {
        if ((this.state & 8) != 0) {
            return false;
        }
        return super.becomeFirstResponder(l, l2);
    }

    void beginGestureWithEvent(long l, long l2, long l3) {
        if (!this.gestureEvent(l, l3, 2)) {
            return;
        }
        super.beginGestureWithEvent(l, l2, l3);
    }

    void endGestureWithEvent(long l, long l2, long l3) {
        if (!this.gestureEvent(l, l3, 4)) {
            return;
        }
        super.endGestureWithEvent(l, l2, l3);
    }

    void calculateVisibleRegion(NSView nSView, long l, boolean bl) {
        long l2 = OS.NewRgn();
        if (!nSView.isHiddenOrHasHiddenAncestor() && this.isDrawing()) {
            long l3 = OS.NewRgn();
            NSWindow nSWindow = nSView.window();
            NSView nSView2 = nSWindow.contentView();
            NSView nSView3 = nSView2.superview();
            NSRect nSRect = nSView2.visibleRect();
            nSRect = nSView2.convertRect_toView_(nSRect, nSView);
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
            OS.RectRgn(l, sArray);
            NSView nSView4 = nSView;
            NSView nSView5 = null;
            while (nSView4.id != nSView3.id) {
                nSRect = nSView4.visibleRect();
                nSRect = nSView4.convertRect_toView_(nSRect, nSView);
                OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
                OS.RectRgn(l2, sArray);
                OS.SectRgn(l2, l, l);
                if (OS.EmptyRgn(l)) break;
                if (bl || nSView4.id != nSView.id) {
                    NSArray nSArray = nSView4.subviews();
                    long l4 = nSArray.count();
                    int n = 0;
                    while ((long)n < l4) {
                        NSView nSView6 = new NSView(nSArray.objectAtIndex(l4 - (long)n - 1L));
                        if (nSView5 != null && nSView6.id == nSView5.id) break;
                        if (!nSView6.isHidden()) {
                            nSRect = nSView6.visibleRect();
                            nSRect = nSView6.convertRect_toView_(nSRect, nSView);
                            OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
                            OS.RectRgn(l2, sArray);
                            OS.UnionRgn(l2, l3, l3);
                        }
                        ++n;
                    }
                }
                nSView5 = nSView4;
                nSView4 = nSView4.superview();
            }
            OS.DiffRgn(l, l3, l);
            OS.DisposeRgn(l3);
        } else {
            OS.CopyRgn(l2, l);
        }
        OS.DisposeRgn(l2);
    }

    void cancelOperation(long l, long l2, long l3) {
        if (this.hasKeyboardFocus(l)) {
            NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
            Shell shell = this.getShell();
            shell.keyInputHappened = false;
            boolean[] blArray = new boolean[1];
            if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                return;
            }
            if (this.isDisposed()) {
                return;
            }
            if (!this.sendKeyEvent(nSEvent, 1)) {
                return;
            }
        }
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0) {
                if (n == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x800) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkToolTip(Widget widget) {
        if (this.isVisible() && this.display.tooltipControl == this && (widget == null || this.display.tooltipTarget == widget)) {
            Shell shell = this.getShell();
            shell.sendToolTipEvent(false);
            shell.sendToolTipEvent(true);
        }
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 64;
        int n4 = 64;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n;
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    NSView contentView() {
        return this.view;
    }

    NSAttributedString createString(String string, Font font, double[] dArray, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        NSObject nSObject;
        NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
        if (font == null) {
            font = this.font != null ? this.font : this.defaultFont();
        }
        nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
        this.addTraits(nSMutableDictionary, font);
        if (bl2) {
            if (dArray != null) {
                nSObject = NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], dArray[3]);
                nSMutableDictionary.setObject(nSObject, OS.NSForegroundColorAttributeName);
            }
        } else {
            nSMutableDictionary.setObject(NSColor.disabledControlTextColor(), OS.NSForegroundColorAttributeName);
        }
        nSObject = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        ((NSMutableParagraphStyle)nSObject).setLineBreakMode(bl ? 0L : 2L);
        if (n != 0) {
            n2 = 0;
            if ((n & 0x1000000) != 0) {
                n2 = 2;
            } else if ((n & 0x20000) != 0) {
                n2 = 1;
            }
            ((NSMutableParagraphStyle)nSObject).setAlignment(n2);
        }
        if ((this.style & 0x4000000) != 0) {
            ((NSMutableParagraphStyle)nSObject).setBaseWritingDirection(1L);
        } else {
            ((NSMutableParagraphStyle)nSObject).setBaseWritingDirection(0L);
        }
        nSMutableDictionary.setObject(nSObject, OS.NSParagraphStyleAttributeName);
        nSObject.release();
        n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, cArray.length, cArray, 0);
        if (bl3) {
            n2 = this.fixMnemonic(cArray);
        }
        NSString nSString = ((NSString)new NSString().alloc()).initWithCharacters(cArray, n2);
        NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, nSMutableDictionary);
        nSString.release();
        nSMutableDictionary.release();
        return nSAttributedString;
    }

    void createWidget() {
        this.state |= 0x40000;
        this.checkOrientation(this.parent);
        super.createWidget();
        this.checkBackground();
        this.checkBuffered();
        this.setDefaultFont();
        this.setZOrder();
        this.setRelations();
        if ((this.state & 0x400) != 0) {
            this.setBackground();
        }
        this.display.clearPool();
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(22);
    }

    Font defaultFont() {
        if (this.display.smallFonts) {
            return this.display.getSystemFont();
        }
        return Font.cocoa_new(this.display, this.defaultNSFont());
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(21);
    }

    NSFont defaultNSFont() {
        return this.display.getSystemFont().handle;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    void destroyWidget() {
        NSView nSView = this.topView();
        nSView.removeFromSuperview();
        this.releaseHandle();
    }

    void doCommandBySelector(long l, long l2, long l3) {
        if (this.hasKeyboardFocus(l)) {
            if (this.imeInComposition()) {
                return;
            }
            Shell shell = this.getShell();
            NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
            if (nSEvent != null && nSEvent.type() == 10L) {
                long l4 = nSEvent.modifierFlags();
                if (!shell.keyInputHappened || (l4 & 0x100000L) != 0L) {
                    shell.keyInputHappened = true;
                    boolean[] blArray = new boolean[1];
                    if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                        return;
                    }
                    if (this.isDisposed()) {
                        return;
                    }
                    if (!this.sendKeyEvent(nSEvent, 1)) {
                        return;
                    }
                    if (blArray[0]) {
                        return;
                    }
                }
            }
            if ((this.state & 2) != 0) {
                return;
            }
        }
        super.doCommandBySelector(l, l2, l3);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 || n2 != 1) {
            return false;
        }
        if (!this.dragDetect(n4, n5, false, null)) {
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        NSEvent nSEvent;
        NSApplication nSApplication = NSApplication.sharedApplication();
        boolean bl2 = false;
        long l = 1L;
        double d = n;
        double d2 = n2;
        NSEvent nSEvent2 = null;
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10L);
        NSDate nSDate = NSDate.dateWithTimeIntervalSinceNow(0.3);
        while (l != 2L) {
            nSEvent = nSApplication.nextEventMatchingMask(68L, nSDate, OS.NSEventTrackingRunLoopMode, true);
            if (nSEvent == null) {
                bl2 = true;
                break;
            }
            l = nSEvent.type();
            if (l == 6L) {
                nSMutableArray.addObject(nSEvent);
                NSPoint nSPoint = nSEvent.locationInWindow();
                NSPoint nSPoint2 = this.view.convertPoint_fromView_(nSPoint, null);
                if (!this.view.isFlipped()) {
                    nSPoint2.y = this.view.bounds().height - nSPoint2.y;
                }
                if (!(Math.abs(nSPoint2.x - d) > 5.0) && !(Math.abs(nSPoint2.y - d2) > 5.0)) continue;
                bl2 = true;
                break;
            }
            if (l != 2L) continue;
            nSEvent2 = nSEvent;
        }
        if (nSEvent2 != null) {
            nSApplication.postEvent(nSEvent2, true);
        }
        if (nSMutableArray.count() > 0L) {
            while (nSMutableArray.count() > 0L) {
                nSEvent = new NSEvent(nSMutableArray.objectAtIndex((long)(nSMutableArray.count() - 1L)).id);
                nSMutableArray.removeLastObject();
                nSApplication.postEvent(nSEvent, true);
            }
        }
        return bl2;
    }

    boolean drawGripper(GC gC, int n, int n2, int n3, int n4, boolean bl) {
        return false;
    }

    boolean drawsBackground() {
        return true;
    }

    void drawWidget(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.paintView().id) {
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        GCData gCData = new GCData();
        gCData.paintRect = nSRect;
        GC gC = GC.cocoa_new(this, gCData);
        Event event = new Event();
        event.gc = gC;
        event.x = (int)nSRect.x;
        event.y = (int)nSRect.y;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendEvent(9, event);
        event.gc = null;
        gC.dispose();
    }

    void enableWidget(boolean bl) {
        if (this.view instanceof NSControl) {
            ((NSControl)this.view).setEnabled(bl);
        }
        this.updateCursorRects(this.isEnabled());
    }

    boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 == null) {
            return dArray == null;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == dArray2[i]) continue;
            return false;
        }
        return true;
    }

    NSView eventView() {
        return this.view;
    }

    void fillBackground(NSView nSView, NSGraphicsContext nSGraphicsContext, NSRect nSRect, int n) {
        this.fillBackground(nSView, nSGraphicsContext, nSRect, n, null, 0, 0);
    }

    void fillBackground(NSView nSView, NSGraphicsContext nSGraphicsContext, NSRect nSRect, int n, NSView nSView2, int n2, int n3) {
        double d;
        Image image;
        if (!this.drawsBackground()) {
            return;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            Object object;
            nSGraphicsContext.saveGraphicsState();
            NSColor.colorWithPatternImage(image.handle).setFill();
            NSPoint nSPoint = new NSPoint();
            NSView nSView3 = control.view;
            if (!nSView3.isFlipped()) {
                nSPoint.y = nSView3.bounds().height;
            }
            if (n == -1) {
                object = nSView3.window().contentView();
                nSPoint = nSView3.convertPoint_toView_(nSPoint, (NSView)object);
                nSPoint.y = ((NSView)object).bounds().height - nSPoint.y;
            } else {
                nSPoint = nSView.convertPoint_toView_(nSPoint, nSView3);
                nSPoint.y += (double)(n - this.backgroundImage.getBounds().height);
            }
            if (nSView2 != null) {
                object = nSView2.convertPoint_toView_(new NSPoint(), nSView);
                nSPoint.x += ((NSPoint)object).x;
                nSPoint.y -= ((NSPoint)object).y;
            }
            nSPoint.x -= (double)n2;
            nSPoint.y += (double)n3;
            nSGraphicsContext.setPatternPhase(nSPoint);
            NSBezierPath.fillRect(nSRect);
            nSGraphicsContext.restoreGraphicsState();
            return;
        }
        double[] dArray = control.background;
        if (dArray == null) {
            if (this.isTransparent()) {
                return;
            }
            dArray = control.defaultBackground().handle;
            d = this.getThemeAlpha();
        } else {
            d = dArray[3];
        }
        nSGraphicsContext.saveGraphicsState();
        NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], d).setFill();
        NSBezierPath.fillRect(nSRect);
        nSGraphicsContext.restoreGraphicsState();
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findBackgroundControl() {
        if (this.backgroundImage != null || this.background != null) {
            return this;
        }
        return !this.isTransparent() && (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    Widget findTooltip(NSPoint nSPoint) {
        return this;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        NSWindow nSWindow = this.view.window();
        if (!nSWindow.makeFirstResponder(null)) {
            nSWindow.endEditingFor(null);
        }
    }

    void flagsChanged(long l, long l2, long l3) {
        if (this.hasKeyboardFocus(l) && (this.state & 0x100000) == 0) {
            Shell shell = this.getShell();
            shell.keyInputHappened = false;
            int n = 0;
            NSEvent nSEvent = new NSEvent(l3);
            long l4 = nSEvent.modifierFlags();
            int n2 = Display.translateKey(nSEvent.keyCode());
            switch (n2) {
                case 65536: {
                    n = 524288;
                    break;
                }
                case 262144: {
                    n = 262144;
                    break;
                }
                case 0x400000: {
                    n = 0x100000;
                    break;
                }
                case 131072: {
                    n = 131072;
                    break;
                }
                case 16777298: {
                    Event event = new Event();
                    event.keyCode = n2;
                    this.setInputState(event, nSEvent, 1);
                    this.sendKeyEvent(1, event);
                    this.setInputState(event, nSEvent, 2);
                    this.sendKeyEvent(2, event);
                }
            }
            if (n != 0) {
                shell.keyInputHappened = true;
                int n3 = ((long)n & l4) != 0L ? 1 : 2;
                Event event = new Event();
                event.keyCode = n2;
                this.setLocationMask(event, nSEvent);
                this.setInputState(event, nSEvent, n3);
                if (!this.sendKeyEvent(n3, event)) {
                    return;
                }
            }
        }
        super.flagsChanged(l, l2, l3);
    }

    NSView focusView() {
        return this.view;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        decorations.setSavedFocus(null);
        NSView nSView = this.focusView();
        if (!nSView.canBecomeKeyView()) {
            return false;
        }
        boolean bl = this.forceFocus(nSView);
        if (this.isDisposed()) {
            return false;
        }
        decorations.setSavedFocus(this);
        decorations.bringToTop(false);
        if (this.isDisposed()) {
            return false;
        }
        return bl;
    }

    boolean forceFocus(NSView nSView) {
        NSWindow nSWindow = this.view.window();
        if (nSWindow == null) {
            return false;
        }
        return nSWindow.makeFirstResponder(nSView);
    }

    boolean gestureEvent(long l, long l2, int n) {
        if (!this.display.sendEvent) {
            return true;
        }
        this.display.sendEvent = false;
        if (this.touchEnabled) {
            return true;
        }
        if (!this.isEventView(l)) {
            return true;
        }
        if (!this.hooks(48) && !this.filters(48)) {
            return true;
        }
        NSEvent nSEvent = new NSEvent(l2);
        Event event = new Event();
        NSView nSView = this.eventView();
        NSPoint nSPoint = nSEvent.locationInWindow();
        NSPoint nSPoint2 = nSView.convertPoint_fromView_(nSPoint, null);
        if (!nSView.isFlipped()) {
            nSPoint2.y = nSView.bounds().height - nSPoint2.y;
        }
        event.x = (int)nSPoint2.x;
        event.y = (int)nSPoint2.y;
        this.setInputState(event, nSEvent, 48);
        event.detail = n;
        if (n == 2) {
            this.display.rotation = 0.0;
            this.display.magnification = 1.0;
            this.display.gestureActive = true;
        } else if (n == 4) {
            this.display.gestureActive = false;
        }
        switch (n) {
            case 16: {
                event.xDirection = (int)(-nSEvent.deltaX());
                event.yDirection = (int)(-nSEvent.deltaY());
                break;
            }
            case 8: {
                this.display.rotation += (double)nSEvent.rotation();
                event.rotation = this.display.rotation;
                break;
            }
            case 32: {
                this.display.magnification *= 1.0 + nSEvent.magnification();
                event.magnification = this.display.magnification;
                break;
            }
            case 64: {
                if (!this.display.gestureActive) break;
                event.xDirection = (int)(-nSEvent.deltaX());
                event.yDirection = (int)(-nSEvent.deltaY());
                if (event.xDirection != 0 || event.yDirection != 0) break;
                return true;
            }
        }
        this.sendEvent(48, event);
        return event.doit;
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.getBackgroundColor();
    }

    Color getBackgroundColor() {
        return this.background != null ? Color.cocoa_new(this.display, this.background) : this.defaultBackground();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        NSRect nSRect = this.topView().frame();
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x40000) != 0;
    }

    boolean getDrawing() {
        return this.drawCount <= 0;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        return this.getForegroundColor();
    }

    Color getForegroundColor() {
        return this.foreground != null ? Color.cocoa_new(this.display, this.foreground) : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        NSRect nSRect = this.topView().frame();
        return new Point((int)nSRect.x, (int)nSRect.y);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMininumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        int n;
        int n2;
        this.checkWidget();
        Monitor[] monitorArray = this.display.getMonitors();
        if (monitorArray.length == 1) {
            return monitorArray[0];
        }
        int n3 = -1;
        int n4 = -1;
        Rectangle rectangle = this.getBounds();
        if (this != this.getShell()) {
            rectangle = this.display.map((Control)this.parent, null, rectangle);
        }
        for (n2 = 0; n2 < monitorArray.length; ++n2) {
            Rectangle rectangle2 = rectangle.intersection(monitorArray[n2].getBounds());
            n = rectangle2.width * rectangle2.height;
            if (n <= 0 || n <= n4) continue;
            n3 = n2;
            n4 = n;
        }
        if (n3 >= 0) {
            return monitorArray[n3];
        }
        n2 = rectangle.x + rectangle.width / 2;
        int n5 = rectangle.y + rectangle.height / 2;
        for (n = 0; n < monitorArray.length; ++n) {
            int n6;
            Rectangle rectangle3 = monitorArray[n].getBounds();
            int n7 = n2 < rectangle3.x ? rectangle3.x - n2 : (n6 = n2 > rectangle3.x + rectangle3.width ? n2 - rectangle3.x - rectangle3.width : 0);
            int n8 = n5 < rectangle3.y ? rectangle3.y - n5 : (n5 > rectangle3.y + rectangle3.height ? n5 - rectangle3.y - rectangle3.height : 0);
            int n9 = n6 * n6 + n8 * n8;
            if (n3 != -1 && n9 >= n4) continue;
            n3 = n;
            n4 = n9;
        }
        return monitorArray[n3];
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    NSBezierPath getPath(Region region) {
        if (region == null) {
            return null;
        }
        return this.getPath(region.handle);
    }

    NSBezierPath getPath(long l) {
        Callback callback = new Callback(this, "regionToRects", 4);
        if (callback.getAddress() == 0L) {
            this.error(3);
        }
        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
        nSBezierPath.retain();
        OS.QDRegionToRects(l, 5, callback.getAddress(), nSBezierPath.id);
        callback.dispose();
        if (nSBezierPath.isEmpty()) {
            nSBezierPath.appendBezierPathWithRect(new NSRect());
        }
        return nSBezierPath;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        NSRect nSRect = this.topView().frame();
        return new Point((int)nSRect.width, (int)nSRect.height);
    }

    public int getTextDirection() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    float getThemeAlpha() {
        return 1.0f * this.parent.getThemeAlpha();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return this.display.getTouchEnabled() && this.touchEnabled;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    long getVisibleRegion() {
        if (this.visibleRgn == 0L) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(this.view, this.visibleRgn, true);
        }
        long l = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, l);
        return l;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    boolean hasFocus() {
        return this.display.getFocusControl() == this;
    }

    boolean hasRegion() {
        return this.region != null || this.parent.hasRegion();
    }

    long hitTest(long l, long l2, NSPoint nSPoint) {
        if ((this.state & 8) != 0) {
            return 0L;
        }
        if (!this.isActive()) {
            return 0L;
        }
        if (this.regionPath != null) {
            NSPoint nSPoint2;
            NSView nSView = this.topView();
            if (!nSView.isFlipped()) {
                nSView = this.eventView();
            }
            if (!this.regionPath.containsPoint(nSPoint2 = nSView.convertPoint_fromView_(nSPoint, new NSView(l).superview()))) {
                return 0L;
            }
        }
        return super.hitTest(l, l2, nSPoint);
    }

    boolean imeInComposition() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertText(long l, long l2, long l3) {
        NSObject nSObject = new NSObject(l3);
        nSObject.retain();
        try {
            if (this.hasKeyboardFocus(l)) {
                long l4;
                Shell shell = this.getShell();
                NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
                if (nSEvent != null && ((l4 = nSEvent.type()) == 10L || l4 == 11L || l4 == 14L)) {
                    NSString nSString = new NSString(l3);
                    if (nSString.isKindOfClass(OS.class_NSAttributedString)) {
                        nSString = new NSAttributedString(l3).string();
                    }
                    int n = (int)nSString.length();
                    char[] cArray = new char[n];
                    nSString.getCharacters(cArray);
                    for (int i = 0; i < cArray.length; ++i) {
                        shell.keyInputHappened = true;
                        Event event = new Event();
                        if (i == 0 && l4 == 10L) {
                            this.setKeyState(event, 1, nSEvent);
                        }
                        event.character = cArray[i];
                        if (this.sendKeyEvent(1, event)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                if ((this.state & 2) != 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = super.insertText(l, l2, l3);
            return bl;
        }
        finally {
            nSObject.release();
        }
    }

    public long internal_new_GC(GCData gCData) {
        Object object;
        NSObject nSObject;
        this.checkWidget();
        NSView nSView = this.paintView();
        long l = 0L;
        if (gCData != null && gCData.paintRect != null) {
            nSObject = NSGraphicsContext.currentContext();
            l = ((NSGraphicsContext)nSObject).id;
            if (!nSView.isFlipped()) {
                gCData.state &= 0xFFFFEFFF;
            }
        } else {
            nSObject = nSView.window();
            if (((NSWindow)nSObject).windowNumber() <= 0L) {
                double d = ((NSWindow)nSObject).alphaValue();
                ((NSWindow)nSObject).setAlphaValue(0.0);
                ((NSWindow)nSObject).orderBack(null);
                ((NSWindow)nSObject).orderOut(null);
                ((NSWindow)nSObject).setAlphaValue(d);
            }
            object = NSGraphicsContext.graphicsContextWithWindow((NSWindow)nSObject);
            NSGraphicsContext nSGraphicsContext = NSGraphicsContext.graphicsContextWithGraphicsPort(((NSGraphicsContext)object).graphicsPort(), true);
            object = nSGraphicsContext;
            l = ((NSGraphicsContext)object).id;
            if (gCData != null) {
                gCData.flippedContext = nSGraphicsContext;
                gCData.state &= 0xFFFFEFFF;
                gCData.visibleRgn = this.getVisibleRegion();
                this.display.addContext(gCData);
            }
        }
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= this.style & (n | 0x8000000);
            }
            gCData.device = this.display;
            gCData.thread = this.display.thread;
            gCData.view = nSView;
            gCData.view.retain();
            gCData.view.window().retain();
            gCData.foreground = this.getForegroundColor().handle;
            object = this.findBackgroundControl();
            if (object == null) {
                object = this;
            }
            gCData.background = ((Control)object).getBackgroundColor().handle;
            gCData.font = this.font != null ? this.font : this.defaultFont();
        }
        return l;
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        this.checkWidget();
        long l2 = l;
        NSGraphicsContext nSGraphicsContext = new NSGraphicsContext(l2);
        this.display.removeContext(gCData);
        if (gCData != null) {
            if (gCData.paintRect == null) {
                nSGraphicsContext.flushGraphics();
            }
            if (gCData.visibleRgn != 0L) {
                OS.DisposeRgn(gCData.visibleRgn);
            }
            gCData.visibleRgn = 0L;
            if (gCData.view != null) {
                gCData.view.window().release();
                gCData.view.release();
                gCData.view = null;
            }
        }
    }

    void invalidateChildrenVisibleRegion() {
    }

    void invalidateVisibleRegion() {
        Control[] controlArray = this.parent._getChildren();
        for (int i = 0; i < controlArray.length && controlArray[i] != this; ++i) {
        }
        for (int i = i; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            control.resetVisibleRegion();
            control.invalidateChildrenVisibleRegion();
        }
        this.parent.resetVisibleRegion();
    }

    boolean isActive() {
        if (this.getShell().getModalShell() != null) {
            return false;
        }
        Dialog dialog = this.display.getModalDialog();
        if (dialog == null) {
            return true;
        }
        NSPanel nSPanel = this.display.getModalPanel();
        if (nSPanel == null) {
            return false;
        }
        NSWindow nSWindow = this.view.window().parentWindow();
        return nSWindow == null || nSWindow.id == nSPanel.id;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isEnabledCursor() {
        return this.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    boolean isObscured() {
        long l = this.getVisibleRegion();
        long l2 = OS.NewRgn();
        short[] sArray = new short[4];
        NSRect nSRect = this.view.visibleRect();
        OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
        OS.RectRgn(l2, sArray);
        OS.DiffRgn(l2, l, l2);
        boolean bl = !OS.EmptyRgn(l2);
        OS.DisposeRgn(l2);
        OS.DisposeRgn(l);
        return bl;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isResizing() {
        return (this.state & 0x80000) != 0 || this.parent.isResizing();
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return true;
            }
        }
        if (((n = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (n & 0x18) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return false;
            }
        }
        return ((n = this.traversalCode(0, null)) & 0x60) != 0;
    }

    boolean isTransparent() {
        if (this.background != null) {
            return false;
        }
        return this.parent.isTransparent();
    }

    boolean isTrim(NSView nSView) {
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void keyDown(long l, long l2, long l3) {
        if (this.hasKeyboardFocus(l)) {
            boolean bl;
            Shell shell = this.getShell();
            shell.keyInputHappened = false;
            boolean bl2 = bl = OS.objc_msgSend(l, OS.sel_conformsToProtocol_, OS.objc_getProtocol("NSTextInput")) != 0L;
            if (!bl) {
                NSEvent nSEvent = new NSEvent(l3);
                boolean[] blArray = new boolean[1];
                if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                if (!this.sendKeyEvent(nSEvent, 1)) {
                    return;
                }
                if (blArray[0]) {
                    return;
                }
            } else {
                super.keyDown(l, l2, l3);
                if (this.imeInComposition()) {
                    return;
                }
                if (!shell.keyInputHappened) {
                    NSEvent nSEvent = new NSEvent(l3);
                    boolean[] blArray = new boolean[1];
                    if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                        return;
                    }
                    if (this.isDisposed()) {
                        return;
                    }
                    if (!this.sendKeyEvent(nSEvent, 1)) {
                        return;
                    }
                    if (blArray[0]) {
                        return;
                    }
                }
                return;
            }
        }
        super.keyDown(l, l2, l3);
    }

    boolean hasKeyboardFocus(long l) {
        return this.view.window().firstResponder().id == l;
    }

    void keyUp(long l, long l2, long l3) {
        NSEvent nSEvent;
        if (this.hasKeyboardFocus(l) && !this.sendKeyEvent(nSEvent = new NSEvent(l3), 2)) {
            return;
        }
        super.keyUp(l, l2, l3);
    }

    void magnifyWithEvent(long l, long l2, long l3) {
        if (!this.gestureEvent(l, l3, 32)) {
            return;
        }
        super.magnifyWithEvent(l, l2, l3);
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    long menuForEvent(long l, long l2, long l3) {
        if (!this.isEnabled()) {
            return 0L;
        }
        NSPoint nSPoint = NSEvent.mouseLocation();
        nSPoint.y = (int)(this.display.getPrimaryFrame().height - nSPoint.y);
        int n = (int)nSPoint.x;
        int n2 = (int)nSPoint.y;
        Event event = new Event();
        event.x = n;
        event.y = n2;
        NSEvent nSEvent = new NSEvent(l3);
        event.detail = nSEvent.buttonNumber() > 0L ? 0 : 1;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return 0L;
        }
        if (!event.doit) {
            return 0L;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (n != event.x || n2 != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0L;
        }
        return super.menuForEvent(l, l2, l3);
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    void scrollWheel(long l, long l2, long l3) {
        boolean bl = false;
        if (l == this.view.id) {
            NSEvent nSEvent = new NSEvent(l3);
            if (!(!this.hooks(48) && !this.filters(48) || nSEvent.deltaY() == 0.0 && nSEvent.deltaX() == 0.0 || this.gestureEvent(l, l3, 64))) {
                bl = true;
            }
            if (!bl) {
                if ((this.hooks(37) || this.filters(37)) && nSEvent.deltaY() != 0.0 && !this.sendMouseEvent(nSEvent, 37, true)) {
                    bl = true;
                }
                if ((this.hooks(38) || this.filters(38)) && nSEvent.deltaX() != 0.0 && !this.sendMouseEvent(nSEvent, 38, true)) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            super.scrollWheel(l, l2, l3);
        }
    }

    boolean isEventView(long l) {
        return true;
    }

    boolean mouseEvent(long l, long l2, long l3, int n) {
        if (!this.display.sendEvent) {
            return true;
        }
        this.display.sendEvent = false;
        if (!this.isEventView(l)) {
            return true;
        }
        boolean bl = false;
        boolean[] blArray = null;
        NSEvent nSEvent = new NSEvent(l3);
        int n2 = (int)nSEvent.type();
        NSInputManager nSInputManager = NSInputManager.currentInputManager();
        if (nSInputManager != null && nSInputManager.wantsToHandleMouseEvents() && nSInputManager.handleMouseEvent(nSEvent)) {
            return true;
        }
        boolean bl2 = false;
        Control control = null;
        switch (n2) {
            case 1: {
                if (nSEvent.clickCount() != 1L || (nSEvent.modifierFlags() & 0x40000L) != 0L || (this.state & 0x40000) == 0 || !this.hooks(29)) break;
                blArray = new boolean[1];
                NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
                if (!this.view.isFlipped()) {
                    nSPoint.y = this.view.bounds().height - nSPoint.y;
                }
                bl = this.dragDetect((int)nSPoint.x, (int)nSPoint.y, false, blArray);
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                bl2 = true;
                control = this;
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                if (this.display.clickCount == 2) {
                    this.sendMouseEvent(nSEvent, 8, false);
                }
                bl2 = true;
                control = this.display.findControl(true);
            }
        }
        this.sendMouseEvent(nSEvent, n, false);
        if (bl) {
            this.sendMouseEvent(nSEvent, 29, false);
        }
        if (bl2) {
            this.display.checkEnterExit(control, nSEvent, false);
        }
        return blArray == null || blArray[0] == false;
    }

    void mouseDown(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 3)) {
            return;
        }
        boolean bl = this.isEventView(l);
        Display display = this.display;
        if (bl) {
            display.trackingControl = this;
        }
        super.mouseDown(l, l2, l3);
        if (bl) {
            display.trackingControl = null;
        }
    }

    void mouseUp(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 4)) {
            return;
        }
        super.mouseUp(l, l2, l3);
    }

    void mouseDragged(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 5)) {
            return;
        }
        super.mouseDragged(l, l2, l3);
    }

    void rightMouseDown(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 3)) {
            return;
        }
        super.rightMouseDown(l, l2, l3);
    }

    void rightMouseUp(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 4)) {
            return;
        }
        super.rightMouseUp(l, l2, l3);
    }

    void rightMouseDragged(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 5)) {
            return;
        }
        super.rightMouseDragged(l, l2, l3);
    }

    void otherMouseDown(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 3)) {
            return;
        }
        super.otherMouseDown(l, l2, l3);
    }

    void otherMouseUp(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 4)) {
            return;
        }
        super.otherMouseUp(l, l2, l3);
    }

    void otherMouseDragged(long l, long l2, long l3) {
        if (!this.mouseEvent(l, l2, l3, 5)) {
            return;
        }
        super.otherMouseDragged(l, l2, l3);
    }

    void moved() {
        this.sendEvent(10);
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl));
    }

    NSView paintView() {
        return this.eventView();
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(gC.handle);
        NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
        nSAffineTransform.translateXBy(0.0, this.view.bounds().height);
        nSAffineTransform.scaleXBy(1.0, -1.0);
        nSAffineTransform.concat();
        this.view.displayRectIgnoringOpacity(this.view.bounds(), gC.handle);
        NSGraphicsContext.static_restoreGraphicsState();
        return true;
    }

    public void redraw() {
        this.checkWidget();
        this.view.setNeedsDisplay(true);
    }

    void redraw(boolean bl) {
        this.view.setNeedsDisplay(true);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        NSRect nSRect = new NSRect();
        nSRect.x = n;
        nSRect.y = n2;
        nSRect.width = n3;
        nSRect.height = n4;
        this.view.setNeedsDisplayInRect(nSRect);
    }

    long regionToRects(long l, long l2, long l3, long l4) {
        NSPoint nSPoint = new NSPoint();
        short[] sArray = new short[4];
        if (l == 2L) {
            C.memmove(sArray, l3, (long)(sArray.length * 2));
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[0];
            OS.objc_msgSend(l4, OS.sel_moveToPoint_, nSPoint);
            nSPoint.x = sArray[3];
            OS.objc_msgSend(l4, OS.sel_lineToPoint_, nSPoint);
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[2];
            OS.objc_msgSend(l4, OS.sel_lineToPoint_, nSPoint);
            nSPoint.x = sArray[1];
            OS.objc_msgSend(l4, OS.sel_lineToPoint_, nSPoint);
            OS.objc_msgSend(l4, OS.sel_closePath);
        }
        return 0L;
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    void release(boolean bl) {
        Control control = null;
        Control control2 = null;
        if (bl && this.parent != null) {
            int n;
            Control[] controlArray = this.parent._getChildren();
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (0 < n && n + 1 < controlArray.length) {
                control = controlArray[n + 1];
                control2 = controlArray[n - 1];
            }
        }
        super.release(bl);
        if (bl && control2 != null) {
            control2.addRelation(control);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
        this.parent = null;
    }

    void releaseParent() {
        this.invalidateVisibleRegion();
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
            this.display.timerExec(-1, this.display.hoverTimer);
        }
        if (this.display.trackingControl == this) {
            this.display.trackingControl = null;
        }
        if (this.display.tooltipControl == this) {
            this.display.tooltipControl = null;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        if (this.visibleRgn != 0L) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0L;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, gestureListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    void removeRelation() {
        NSControl nSControl;
        if (!this.isDescribedByLabel()) {
            return;
        }
        NSObject nSObject = this.focusView();
        if (nSObject instanceof NSControl && (nSControl = (NSControl)nSObject).cell() != null) {
            nSObject = nSControl.cell();
        }
        nSObject.accessibilitySetOverrideValue(nSObject, OS.NSAccessibilityTitleUIElementAttribute);
    }

    public void removeTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, touchListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    void resetVisibleRegion() {
        GCData[] gCDataArray;
        if (this.visibleRgn != 0L) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0L;
        }
        if ((gCDataArray = this.display.contexts) != null) {
            long l = 0L;
            for (int i = 0; i < gCDataArray.length; ++i) {
                GCData gCData = gCDataArray[i];
                if (gCData == null || gCData.view != this.view) continue;
                if (l == 0L) {
                    l = this.getVisibleRegion();
                }
                gCData.state &= 0xFFFFEFFF;
                OS.CopyRgn(l, gCData.visibleRgn);
            }
            if (l != 0L) {
                OS.DisposeRgn(l);
            }
        }
    }

    void resized() {
        this.sendEvent(11);
    }

    void rotateWithEvent(long l, long l2, long l3) {
        if (!this.gestureEvent(l, l3, 8)) {
            return;
        }
        super.rotateWithEvent(l, l2, l3);
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4) {
        Event event = new Event();
        event.button = n;
        event.x = n3;
        event.y = n4;
        event.stateMask = n2;
        this.postEvent(29, event);
        return event.doit;
    }

    void sendFocusEvent(int n) {
        Display display = this.display;
        Shell shell = this.getShell();
        display.focusEvent = n;
        display.focusControl = this;
        this.sendEvent(n);
        display.focusEvent = 0;
        display.focusControl = null;
        if (!shell.isDisposed()) {
            switch (n) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        NSPoint nSPoint;
        Object object;
        Shell shell = null;
        Event event = new Event();
        switch (n) {
            case 3: {
                shell = this.getShell();
            }
            case 4: 
            case 8: 
            case 29: {
                int n2 = (int)nSEvent.buttonNumber();
                switch (n2) {
                    case 0: {
                        event.button = 1;
                        break;
                    }
                    case 1: {
                        event.button = 3;
                        break;
                    }
                    case 2: {
                        event.button = 2;
                        break;
                    }
                    case 3: {
                        event.button = 4;
                        break;
                    }
                    case 4: {
                        event.button = 5;
                    }
                }
                break;
            }
            case 37: {
                event.detail = 1;
                double d = nSEvent.deltaY();
                event.count = d > 0.0 ? Math.max(1, (int)d) : Math.min(-1, (int)d);
                break;
            }
            case 38: {
                double d = nSEvent.deltaX();
                event.count = d > 0.0 ? Math.max(1, (int)d) : Math.min(-1, (int)d);
                break;
            }
        }
        if (event.button != 0) {
            event.count = this.display.clickCount;
        }
        NSView nSView = this.eventView();
        if (nSEvent == null || nSEvent.type() == 5L) {
            object = nSView.window();
            nSPoint = ((NSWindow)object).convertScreenToBase(NSEvent.mouseLocation());
        } else {
            nSPoint = nSEvent.locationInWindow();
        }
        object = nSView.convertPoint_fromView_(nSPoint, null);
        if (!nSView.isFlipped()) {
            ((NSPoint)object).y = nSView.bounds().height - ((NSPoint)object).y;
        }
        event.x = (int)((NSPoint)object).x;
        event.y = (int)((NSPoint)object).y;
        this.setInputState(event, nSEvent, n);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        if (shell != null) {
            shell.setActiveControl(this, 3);
        }
        return event.doit;
    }

    Touch touchStateFromNSTouch(NSTouch nSTouch) {
        TouchSource touchSource = this.display.findTouchSource(nSTouch);
        long l = nSTouch.phase();
        long l2 = OS.objc_msgSend(nSTouch.id, OS.sel_identity);
        int n = 0;
        switch ((int)l) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 8: 
            case 16: {
                n = 4;
            }
        }
        ++this.display.touchCounter;
        boolean bl = false;
        NSPoint nSPoint = nSTouch.normalizedPosition();
        double d = nSPoint.x;
        double d2 = 1.0 - nSPoint.y;
        if (this.display.currentTouches().count() == 1L) {
            this.display.primaryIdentifier = l2;
        }
        if (this.display.primaryIdentifier == l2) {
            bl = true;
        }
        NSSize nSSize = nSTouch.deviceSize();
        int n2 = (int)(d * nSSize.width);
        int n3 = (int)(d2 * nSSize.height);
        Touch touch = new Touch(l2, touchSource, n, bl, n2, n3);
        return touch;
    }

    NSTouch findTouchWithId(NSArray nSArray, NSObject nSObject) {
        long l = nSArray.count();
        for (long i = 0L; i < l; ++i) {
            NSTouch nSTouch = new NSTouch(nSArray.objectAtIndex((long)i).id);
            NSObject nSObject2 = new NSObject(OS.objc_msgSend(nSTouch.id, OS.sel_identity));
            if (!nSObject2.isEqual(nSObject)) continue;
            return nSTouch;
        }
        return null;
    }

    void setBackground() {
        if (!this.drawsBackground()) {
            return;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.setBackgroundImage(control.backgroundImage.handle);
        } else {
            double[] dArray = control.background != null ? control.background : control.defaultBackground().handle;
            NSColor nSColor = NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], dArray[3]);
            this.setBackgroundColor(nSColor);
        }
    }

    public void setBackground(Color color) {
        double[] dArray;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray2 = dArray = color != null ? color.handle : null;
        if (this.equals(dArray, this.background)) {
            return;
        }
        this.background = dArray;
        this.updateBackgroundColor();
        this.redrawWidget(this.view, true);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        this.updateBackgroundImage();
    }

    void setBackgroundImage(NSImage nSImage) {
        this.redrawWidget(this.view, true);
    }

    void setBackgroundColor(NSColor nSColor) {
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true);
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Display display = this.display;
        boolean bl3 = display.ignoreFocus;
        display.ignoreFocus = true;
        NSView nSView = this.topView();
        if (bl && bl2) {
            NSRect nSRect = new NSRect();
            nSRect.x = n;
            nSRect.y = n2;
            nSRect.width = n3;
            nSRect.height = n4;
            nSView.setFrame(nSRect);
        } else if (bl) {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            nSView.setFrameOrigin(nSPoint);
        } else if (bl2) {
            NSSize nSSize = new NSSize();
            nSSize.width = n3;
            nSSize.height = n4;
            nSView.setFrameSize(nSSize);
        }
        display.ignoreFocus = bl3;
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
    }

    void setClipRegion(NSView nSView) {
        if (this.regionPath != null) {
            NSView nSView2 = this.topView();
            if (!nSView2.isFlipped()) {
                nSView2 = this.eventView();
            }
            NSPoint nSPoint = nSView.convertPoint_toView_(new NSPoint(), nSView2);
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(-nSPoint.x, -nSPoint.y);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
            this.regionPath.addClip();
            nSAffineTransform.translateXBy(2.0 * nSPoint.x, 2.0 * nSPoint.y);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
        }
        this.parent.setClipRegion(nSView);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.view.window().areCursorRectsEnabled()) {
            return;
        }
        this.display.setCursor(this.display.currentControl);
    }

    void setDefaultFont() {
        if (this.display.smallFonts) {
            this.setFont(this.defaultFont().handle);
            this.setSmallSize();
        }
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x40000) : (this.state &= 0xFFFBFFFF);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(bl);
        if (bl2) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        this.setFont(font != null ? font.handle : this.defaultFont().handle);
    }

    void setFont(NSFont nSFont) {
        if (this.view instanceof NSControl) {
            ((NSControl)this.view).setFont(nSFont);
        }
    }

    public void setForeground(Color color) {
        double[] dArray;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray2 = dArray = color != null ? color.handle : null;
        if (this.equals(dArray, this.foreground)) {
            return;
        }
        this.foreground = dArray;
        this.setForeground(dArray);
        this.redrawWidget(this.view, false);
    }

    void setForeground(double[] dArray) {
    }

    void setFrameOrigin(long l, long l2, NSPoint nSPoint) {
        NSView nSView = this.topView();
        if (nSView.id != l) {
            super.setFrameOrigin(l, l2, nSPoint);
            return;
        }
        NSRect nSRect = nSView.frame();
        super.setFrameOrigin(l, l2, nSPoint);
        if (nSRect.x != nSPoint.x || nSRect.y != nSPoint.y) {
            this.invalidateVisibleRegion();
            this.moved();
        }
    }

    void setFrameSize(long l, long l2, NSSize nSSize) {
        NSView nSView = this.topView();
        if (nSView.id != l) {
            super.setFrameSize(l, l2, nSSize);
            return;
        }
        NSRect nSRect = nSView.frame();
        super.setFrameSize(l, l2, nSSize);
        if (nSRect.width != nSSize.width || nSRect.height != nSSize.height) {
            this.invalidateVisibleRegion();
            boolean bl = (this.state & 0x80000) != 0;
            this.state |= 0x80000;
            this.resized();
            if (!bl) {
                this.state &= 0xFFF7FFFF;
            }
        }
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public boolean setParent(Composite composite) {
        Object object;
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            this.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        if (shell2 != shell || decorations2 != decorations) {
            object = shell2.findMenus(this);
            this.fixChildren(shell, shell2, decorations, decorations2, (Menu[])object);
        }
        object = this.topView();
        ((NSObject)object).retain();
        ((NSView)object).removeFromSuperview();
        composite.contentView().addSubview((NSView)object, -1L, null);
        ((NSObject)object).release();
        this.parent = composite;
        this.reskin(1);
        return true;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0) {
                this.invalidateVisibleRegion();
                this.redrawWidget(this.topView(), true);
            }
        } else {
            if (this.drawCount == 0) {
                this.invalidateVisibleRegion();
            }
            ++this.drawCount;
        }
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = this.getPath(region);
        this.redrawWidget(this.view, true);
    }

    void setRelations() {
        Control control;
        if (this.parent == null) {
            return;
        }
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        if (n > 1 && (control = controlArray[n - 2]) != this) {
            control.addRelation(this);
        }
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    void setSmallSize() {
        NSCell nSCell;
        if (this.view instanceof NSControl && (nSCell = ((NSControl)this.view).cell()) != null) {
            nSCell.setControlSize(1L);
        }
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int n) {
        this.checkWidget();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.checkToolTip(null);
    }

    public void setTouchEnabled(boolean bl) {
        this.checkWidget();
        this.eventView().setAcceptsTouchEvents(bl);
        this.touchEnabled = bl;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.topView().setHidden(!bl);
        if (this.isDisposed()) {
            return;
        }
        this.invalidateVisibleRegion();
        if (!bl) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    void setZOrder() {
        NSView nSView = this.topView();
        this.parent.contentView().addSubview(nSView, -1L, null);
    }

    boolean shouldDelayWindowOrderingForEvent(long l, long l2, long l3) {
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0) {
            return false;
        }
        return super.shouldDelayWindowOrderingForEvent(l, l2, l3);
    }

    void setZOrder(Control control, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = -1;
        Control[] controlArray = null;
        controlArray = this.parent._getChildren();
        for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
        }
        if (control != null) {
            while (n2 < controlArray.length && controlArray[n2] != control) {
                ++n2;
            }
        }
        this.removeRelation();
        if (n + 1 < controlArray.length) {
            n3 = n + 1;
            controlArray[n3].removeRelation();
        }
        if (control != null) {
            if (bl) {
                control.removeRelation();
            } else if (n2 + 1 < controlArray.length) {
                controlArray[n2 + 1].removeRelation();
            }
        }
        NSView nSView = control == null ? null : control.topView();
        NSView nSView2 = this.topView();
        nSView2.retain();
        nSView2.removeFromSuperview();
        this.parent.contentView().addSubview(nSView2, bl ? 1L : -1L, nSView);
        nSView2.release();
        this.invalidateVisibleRegion();
        n = control != null ? (bl ? n2 - (n < n2 ? 1 : 0) : n2 + (n2 < n ? 1 : 0)) : (bl ? 0 : controlArray.length - 1);
        controlArray = this.parent._getChildren();
        if (0 < n) {
            controlArray[n - 1].addRelation(this);
        }
        if (n + 1 < controlArray.length) {
            this.addRelation(controlArray[n + 1]);
        }
        if (n3 != -1) {
            if (n3 <= n) {
                --n3;
            }
            if (0 < n3 && n3 != n && n3 != n + 1) {
                controlArray[n3 - 1].addRelation(controlArray[n3]);
            }
        }
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (nArray[k] > nArray[k + i]) continue;
                    int n2 = nArray[k];
                    nArray[k] = nArray[k + i];
                    nArray[k + i] = n2;
                }
            }
        }
    }

    void swipeWithEvent(long l, long l2, long l3) {
        if (!this.gestureEvent(l, l3, 16)) {
            return;
        }
        super.swipeWithEvent(l, l2, l3);
    }

    NSSize textExtent(String string) {
        NSAttributedString nSAttributedString = this.createString(string, null, null, 0, false, true, false);
        NSSize nSSize = nSAttributedString.size();
        nSAttributedString.release();
        return nSSize;
    }

    String tooltipText() {
        return this.toolTipText;
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        return this.display.map(null, this, n, n2);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        return this.display.map(this, null, n, n2);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    NSView topView() {
        return this.view;
    }

    boolean touchEvent(long l, long l2, long l3) {
        NSObject nSObject;
        NSObject nSObject2;
        NSObject nSObject3;
        if (!this.display.sendEvent) {
            return true;
        }
        this.display.sendEvent = false;
        if (!this.hooks(47) && !this.filters(47)) {
            return true;
        }
        if (!this.isEventView(l)) {
            return true;
        }
        if (!this.touchEnabled) {
            return true;
        }
        NSEvent nSEvent = new NSEvent(l3);
        NSMutableArray nSMutableArray = this.display.currentTouches();
        Event event = new Event();
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
        if (!this.view.isFlipped()) {
            nSPoint.y = this.view.bounds().height - nSPoint.y;
        }
        event.x = (int)nSPoint.x;
        event.y = (int)nSPoint.y;
        this.setInputState(event, nSEvent, 47);
        NSSet nSSet = nSEvent.touchesMatchingPhase(-1L, null);
        long l4 = nSSet.count();
        Touch[] touchArray = new Touch[(int)l4];
        int n = 0;
        NSArray nSArray = nSEvent.touchesMatchingPhase(24L, null).allObjects();
        int n2 = 0;
        while ((long)n2 < nSArray.count()) {
            NSTouch nSTouch = new NSTouch(nSArray.objectAtIndex((long)((long)n2)).id);
            nSObject3 = new NSObject(OS.objc_msgSend(nSTouch.id, OS.sel_identity));
            nSObject2 = this.findTouchWithId(nSMutableArray, nSObject3);
            if (nSObject2 != null) {
                nSMutableArray.removeObject(nSObject2);
            }
            touchArray[n++] = this.touchStateFromNSTouch(nSTouch);
            ++n2;
        }
        if (nSMutableArray.count() == 0L) {
            this.display.touchCounter = 0;
        }
        NSArray nSArray2 = nSEvent.touchesMatchingPhase(7L, null).allObjects();
        int n3 = 0;
        while ((long)n3 < nSArray2.count()) {
            nSObject3 = new NSTouch(nSArray2.objectAtIndex((long)((long)n3)).id);
            nSObject2 = new NSObject(OS.objc_msgSend(((NSTouch)nSObject3).id, OS.sel_identity));
            nSObject = this.findTouchWithId(nSMutableArray, nSObject2);
            if (nSObject == null) {
                nSMutableArray.addObject(nSObject3);
            }
            touchArray[n++] = this.touchStateFromNSTouch((NSTouch)nSObject3);
            ++n3;
        }
        if (nSArray2.count() != nSMutableArray.count()) {
            for (long i = nSMutableArray.count() - 1L; i >= 0L; --i) {
                nSObject2 = new NSTouch(nSMutableArray.objectAtIndex((long)i).id);
                nSObject = new NSObject(OS.objc_msgSend(nSObject2.id, OS.sel_identity));
                NSTouch nSTouch = this.findTouchWithId(nSArray2, nSObject);
                if (nSTouch != null) continue;
                Touch touch = this.touchStateFromNSTouch((NSTouch)nSObject2);
                touch.state = 4;
                if (n == touchArray.length) {
                    Touch[] touchArray2 = new Touch[touchArray.length + 1];
                    System.arraycopy(touchArray, 0, touchArray2, 0, touchArray.length);
                    touchArray = touchArray2;
                }
                touchArray[n++] = touch;
                nSMutableArray.removeObject(nSTouch);
            }
        }
        event.touches = touchArray;
        this.postEvent(47, event);
        return true;
    }

    void touchesBeganWithEvent(long l, long l2, long l3) {
        if (!this.touchEvent(l, l2, l3)) {
            return;
        }
        super.touchesBeganWithEvent(l, l2, l3);
    }

    void touchesCancelledWithEvent(long l, long l2, long l3) {
        if (!this.touchEvent(l, l2, l3)) {
            return;
        }
        super.touchesCancelledWithEvent(l, l2, l3);
    }

    void touchesEndedWithEvent(long l, long l2, long l3) {
        if (!this.touchEvent(l, l2, l3)) {
            return;
        }
        super.touchesEndedWithEvent(l, l2, l3);
    }

    void touchesMovedWithEvent(long l, long l2, long l3) {
        if (!this.touchEvent(l, l2, l3)) {
            return;
        }
        super.touchesMovedWithEvent(l, l2, l3);
    }

    boolean translateTraversal(int n, NSEvent nSEvent, boolean[] blArray) {
        int n2 = 0;
        int n3 = this.traversalCode(n, nSEvent);
        boolean bl = false;
        switch (n) {
            case 53: {
                bl = true;
                n2 = 2;
                break;
            }
            case 36: 
            case 76: {
                bl = true;
                n2 = 4;
                break;
            }
            case 48: {
                long l = nSEvent.modifierFlags();
                boolean bl2 = (l & 0x20000L) == 0L;
                n2 = bl2 ? 16 : 8;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                boolean bl3 = n == 125 || n == 124;
                n2 = bl3 ? 64 : 32;
                break;
            }
            case 116: 
            case 121: {
                bl = true;
                long l = nSEvent.modifierFlags();
                if ((l & 0x40000L) == 0L) {
                    return false;
                }
                n2 = n == 121 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        blArray[0] = (n3 & n2) != 0;
        event.doit = blArray[0];
        event.detail = n2;
        if (!this.setKeyState(event, 31, nSEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl && control != null);
        return false;
    }

    int traversalCode(int n, NSEvent nSEvent) {
        int n2 = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            n2 |= 2;
        }
        return n2;
    }

    boolean traverseMnemonic(char c) {
        return false;
    }

    public boolean traverse(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(n, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int n, KeyEvent keyEvent) {
        this.checkWidget();
        if (keyEvent == null) {
            this.error(4);
        }
        return this.traverse(n, keyEvent.character, keyEvent.keyCode, keyEvent.keyLocation, keyEvent.stateMask, keyEvent.doit);
    }

    boolean traverse(int n, char c, int n2, int n3, int n4, boolean bl) {
        if (n == 0) {
            switch (n2) {
                case 27: {
                    n = 2;
                    bl = true;
                    break;
                }
                case 13: {
                    n = 4;
                    bl = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    n = 64;
                    bl = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 9: {
                    n = (n4 & 0x20000) != 0 ? 8 : 16;
                    bl = true;
                    break;
                }
                case 0x1000006: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 512;
                    bl = true;
                    break;
                }
                case 0x1000005: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 256;
                    bl = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        Event event = new Event();
        event.character = c;
        event.detail = n;
        event.doit = bl;
        event.keyCode = n2;
        event.keyLocation = n3;
        event.stateMask = n4;
        Shell shell = this.getShell();
        boolean bl2 = false;
        switch (n) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                bl2 = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl2 && control != null);
        return false;
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        int n;
        int n2;
        Control control = this.computeTabRoot();
        Widget widget = this.computeTabGroup();
        Widget[] widgetArray = control.computeTabList();
        int n3 = widgetArray.length;
        for (n2 = 0; n2 < n3 && widgetArray[n2] != widget; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Widget widget2 = widgetArray[n2];
            if (widget2.isDisposed() || !widget2.setTabGroupFocus()) continue;
            return true;
        }
        if (widget.isDisposed()) {
            return false;
        }
        return widget.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl) {
        int n;
        int n2;
        Control[] controlArray = this.parent._getChildren();
        int n3 = controlArray.length;
        for (n2 = 0; n2 < n3 && controlArray[n2] != this; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(boolean bl) {
        NSMutableArray nSMutableArray = this.display.isPainting;
        if (nSMutableArray.containsObject(this.view)) {
            return;
        }
        int n = (int)nSMutableArray.count();
        for (int i = 0; i < n; ++i) {
            NSView nSView = new NSView(nSMutableArray.objectAtIndex(i));
            if (!nSView.isDescendantOf(this.view)) continue;
            return;
        }
        if (this.isResizing()) {
            return;
        }
        Shell shell = this.getShell();
        NSWindow nSWindow = shell.deferFlushing && shell.scrolling ? this.view.window() : null;
        try {
            if (nSWindow != null) {
                nSWindow.retain();
                nSWindow.disableFlushWindow();
            }
            this.view.displayIfNeeded();
        }
        finally {
            if (nSWindow != null) {
                nSWindow.enableFlushWindow();
                nSWindow.release();
            }
        }
    }

    void updateBackgroundColor() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        double[] dArray = control.background != null ? control.background : control.defaultBackground().handle;
        NSColor nSColor = NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], dArray[3]);
        this.setBackgroundColor(nSColor);
    }

    void updateBackgroundImage() {
        Control control = this.findBackgroundControl();
        Image image = control != null ? control.backgroundImage : this.backgroundImage;
        this.setBackgroundImage(image != null ? image.handle : null);
    }

    void updateBackgroundMode() {
        int n = this.state & 0x400;
        this.checkBackground();
        if (n != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void resetCursorRects(long l, long l2) {
        if (this.isEnabled()) {
            this.callSuper(l, l2);
        }
    }

    void updateTrackingAreas(long l, long l2) {
        if (this.isEnabled()) {
            this.callSuper(l, l2);
        }
    }

    void updateCursorRects(boolean bl) {
        this.updateCursorRects(bl, this.view);
    }

    void updateCursorRects(boolean bl, NSView nSView) {
        if (bl) {
            nSView.resetCursorRects();
            nSView.updateTrackingAreas();
        } else {
            nSView.discardCursorRects();
            NSArray nSArray = nSView.trackingAreas();
            int n = 0;
            while ((long)n < nSArray.count()) {
                nSView.removeTrackingArea(new NSTrackingArea(nSArray.objectAtIndex(n)));
                ++n;
            }
        }
    }

    void updateLayout(boolean bl) {
    }
}

