PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE meta (  name  TEXT UNIQUE,   value TEXT );
INSERT INTO meta VALUES('version','8');
INSERT INTO meta VALUES('datetime','2024-06-15 02:37:52');
CREATE TABLE uuids (  id      INTEGER PRIMARY KEY,   jobUUID TEXT UNIQUE NOT NULL );
INSERT INTO uuids VALUES(1,'daa50cfb-5ada-4f65-ae9d-75ba194cc52d');
CREATE TABLE entities (  id                        INTEGER PRIMARY KEY,   jobUUID                   TEXT NOT NULL,   scheduleUUID              TEXT NOT NULL DEFAULT '',   hostName                  TEXT,   userName                  TEXT,   created                   INTEGER,   type                      INTEGER,   parentJobUUID             INTEGER,   bidFlag                   INTEGER DEFAULT 0,   lockedCount               INTEGER DEFAULT 0,   deletedFlag               INTEGER DEFAULT 0,   totalEntryCount           INTEGER DEFAULT 0,   totalEntrySize            INTEGER DEFAULT 0,   totalFileCount            INTEGER DEFAULT 0,   totalFileSize             INTEGER DEFAULT 0,   totalImageCount           INTEGER DEFAULT 0,   totalImageSize            INTEGER DEFAULT 0,   totalDirectoryCount       INTEGER DEFAULT 0,   totalLinkCount            INTEGER DEFAULT 0,   totalHardlinkCount        INTEGER DEFAULT 0,   totalHardlinkSize         INTEGER DEFAULT 0,   totalSpecialCount         INTEGER DEFAULT 0,   totalEntryCountNewest     INTEGER DEFAULT 0,   totalEntrySizeNewest      INTEGER DEFAULT 0,   totalFileCountNewest      INTEGER DEFAULT 0,   totalFileSizeNewest       INTEGER DEFAULT 0,   totalImageCountNewest     INTEGER DEFAULT 0,   totalImageSizeNewest      INTEGER DEFAULT 0,   totalDirectoryCountNewest INTEGER DEFAULT 0,   totalLinkCountNewest      INTEGER DEFAULT 0,   totalHardlinkCountNewest  INTEGER DEFAULT 0,   totalHardlinkSizeNewest   INTEGER DEFAULT 0,   totalSpecialCountNewest   INTEGER DEFAULT 0,   uuidId                    INTEGER DEFAULT 0 );
INSERT INTO entities VALUES(0,'','',NULL,NULL,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
INSERT INTO entities VALUES(1,'daa50cfb-5ada-4f65-ae9d-75ba194cc52d','a9a71610-cb3f-4908-8a69-c260a92ac663','tooku','torsten',1718419087,1,NULL,0,0,0,64,10694403,35,4400899,0,0,6,4,14,6293504,5,64,10165995,35,3874539,0,0,6,4,14,6291456,5,1);
CREATE TABLE storages (  id                        INTEGER PRIMARY KEY,   entityId                  INTEGER REFERENCES entities(id) ON DELETE CASCADE,   name                      TEXT,   created                   INTEGER,   size                      INTEGER DEFAULT 0,   hostName                  TEXT,   userName                  TEXT,   comment                   TEXT,   state                     INTEGER DEFAULT 2,   mode                      INTEGER DEFAULT 0,   lastChecked               INTEGER DEFAULT 0,   errorMessage              TEXT,   deletedFlag               INTEGER DEFAULT 0,   totalEntryCount           INTEGER DEFAULT 0,   totalEntrySize            INTEGER DEFAULT 0,   totalFileCount            INTEGER DEFAULT 0,   totalFileSize             INTEGER DEFAULT 0,   totalImageCount           INTEGER DEFAULT 0,   totalImageSize            INTEGER DEFAULT 0,   totalDirectoryCount       INTEGER DEFAULT 0,   totalLinkCount            INTEGER DEFAULT 0,   totalHardlinkCount        INTEGER DEFAULT 0,   totalHardlinkSize         INTEGER DEFAULT 0,   totalSpecialCount         INTEGER DEFAULT 0,   totalEntryCountNewest     INTEGER DEFAULT 0,   totalEntrySizeNewest      INTEGER DEFAULT 0,   totalFileCountNewest      INTEGER DEFAULT 0,   totalFileSizeNewest       INTEGER DEFAULT 0,   totalImageCountNewest     INTEGER DEFAULT 0,   totalImageSizeNewest      INTEGER DEFAULT 0,   totalDirectoryCountNewest INTEGER DEFAULT 0,   totalLinkCountNewest      INTEGER DEFAULT 0,   totalHardlinkCountNewest  INTEGER DEFAULT 0,   totalHardlinkSizeNewest   INTEGER DEFAULT 0,   totalSpecialCountNewest   INTEGER DEFAULT 0,   uuidId                    INTEGER DEFAULT 0 );
INSERT INTO storages VALUES(1,1,'/tmp/test.bar',1718419087,6507242,'tooku','torsten',NULL,1,1,1718419087,NULL,0,64,10694403,35,4400899,0,0,6,4,14,6293504,5,64,10694403,35,4400899,0,0,6,4,14,6293504,5,1);
PRAGMA writable_schema=ON;
INSERT INTO sqlite_schema(type,name,tbl_name,rootpage,sql)VALUES('table','FTS_storages','FTS_storages',0,'CREATE VIRTUAL TABLE FTS_storages USING FTS5(  storageId,   name,   tokenize=unicode61 )');
CREATE TABLE IF NOT EXISTS 'FTS_storages_data'(id INTEGER PRIMARY KEY, block BLOB);
INSERT INTO FTS_storages_data VALUES(1,X'010103');
INSERT INTO FTS_storages_data VALUES(10,X'000000000102020002010101020101');
INSERT INTO FTS_storages_data VALUES(137438953473,X'0000000a02303101020204');
INSERT INTO FTS_storages_data VALUES(274877906945,X'0000002802303101030201036261720106010104010474657374010601010302026d70010601010204060a0b');
CREATE TABLE IF NOT EXISTS 'FTS_storages_idx'(segid, term, pgno, PRIMARY KEY(segid, term)) WITHOUT ROWID;
INSERT INTO FTS_storages_idx VALUES(1,X'',2);
INSERT INTO FTS_storages_idx VALUES(2,X'',2);
CREATE TABLE IF NOT EXISTS 'FTS_storages_content'(id INTEGER PRIMARY KEY, c0, c1);
INSERT INTO FTS_storages_content VALUES(1,1,'/tmp/test.bar');
CREATE TABLE IF NOT EXISTS 'FTS_storages_docsize'(id INTEGER PRIMARY KEY, sz BLOB);
INSERT INTO FTS_storages_docsize VALUES(1,X'0103');
CREATE TABLE IF NOT EXISTS 'FTS_storages_config'(k PRIMARY KEY, v) WITHOUT ROWID;
INSERT INTO FTS_storages_config VALUES('version',4);
CREATE TABLE entries (  id              INTEGER PRIMARY KEY,   entityId        INTEGER REFERENCES entities(id) ON DELETE CASCADE,   type            INTEGER,   name            TEXT NOT NULL,   timeLastAccess  INTEGER,   timeModified    INTEGER,   timeLastChanged INTEGER,   userId          INTEGER,   groupId         INTEGER,   permission      INTEGER,   deletedFlag     INTEGER DEFAULT 0,   archiveOffset   INTEGER,   uuidId          INTEGER DEFAULT 0,   size            INTEGER DEFAULT 0 );
INSERT INTO entries VALUES(1,1,7,'tests/data',1718417218,1718326783,1718326783,1000,1000,16877,0,NULL,1,0);
INSERT INTO entries VALUES(2,1,10,'tests/data/fifo.ext',1718325625,1718325625,1718325625,1000,1000,4532,0,NULL,1,0);
INSERT INTO entries VALUES(3,1,5,'tests/data/file400.dat',1718325625,1718325625,1718325625,1000,1000,33024,0,NULL,1,1024);
INSERT INTO entries VALUES(4,1,5,'tests/data/file664.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,1024);
INSERT INTO entries VALUES(5,1,5,'tests/data/name".dat',1718326783,1718326783,1718326783,1000,1000,33204,0,NULL,1,12);
INSERT INTO entries VALUES(6,1,5,'tests/data/extended_attribute.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,1024);
INSERT INTO entries VALUES(7,1,5,'tests/data/zero128.dat',1718417638,1718417638,1718417638,1000,1000,33204,0,NULL,1,128);
INSERT INTO entries VALUES(8,1,5,'tests/data/immutable.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,18);
INSERT INTO entries VALUES(9,1,5,'tests/data/encodingCP1252-',1718326783,1718417634,1718417634,1000,1000,33204,0,NULL,1,12);
INSERT INTO entries VALUES(10,1,5,'tests/data/random128.dat',1718417638,1718417638,1718417638,1000,1000,33204,0,NULL,1,128);
INSERT INTO entries VALUES(11,1,9,'tests/data/hardlink_extended_attribute.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,1024);
INSERT INTO entries VALUES(12,1,9,'tests/data/hardlinkdata_extended_attribute.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,1024);
INSERT INTO entries VALUES(13,1,10,'tests/data/fifo',1718325625,1718325625,1718325625,1000,1000,4532,0,NULL,1,0);
INSERT INTO entries VALUES(14,1,5,'tests/data/sparse.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,196608);
INSERT INTO entries VALUES(15,1,5,'tests/data/readonly.dat',1718325625,1718325625,1718325625,1000,1000,33056,0,NULL,1,12);
INSERT INTO entries VALUES(16,1,8,'tests/data/link_not_existing_file.dat',1718417403,1718325625,1718325625,1000,1000,41471,0,NULL,1,0);
INSERT INTO entries VALUES(17,1,8,'tests/data/circular_link.dat',1718370603,1718325625,1718325625,1000,1000,41471,0,NULL,1,0);
INSERT INTO entries VALUES(18,1,5,'tests/data/file666.dat',1718325625,1718325625,1718325625,1000,1000,33206,0,NULL,1,1024);
INSERT INTO entries VALUES(19,1,5,'tests/data/circular_link.dat.marker',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,0);
INSERT INTO entries VALUES(20,1,10,'tests/data/character_device',1718325625,1718325625,1718325625,0,0,8614,0,NULL,1,0);
INSERT INTO entries VALUES(21,1,10,'tests/data/block_device',1718325625,1718325625,1718325625,0,0,24998,0,NULL,1,0);
INSERT INTO entries VALUES(22,1,5,'tests/data/file_big_group_id.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,1024);
INSERT INTO entries VALUES(23,1,5,'tests/data/encodingUTF8-äöüÄÖÜß',1718326783,1718417634,1718417634,1000,1000,33204,0,NULL,1,12);
INSERT INTO entries VALUES(24,1,5,'tests/data/file640.dat',1718325625,1718325625,1718325625,1000,1000,33184,0,NULL,1,1024);
INSERT INTO entries VALUES(25,1,5,'tests/data/file644.dat',1718325625,1718325625,1718325625,1000,1000,33188,0,NULL,1,1024);
INSERT INTO entries VALUES(26,1,5,'tests/data/name\.dat',1718326783,1718326783,1718326783,1000,1000,33204,0,NULL,1,12);
INSERT INTO entries VALUES(27,1,5,'tests/data/append-only.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,17);
INSERT INTO entries VALUES(28,1,5,'tests/data/name''.dat',1718326783,1718326783,1718326783,1000,1000,33204,0,NULL,1,12);
INSERT INTO entries VALUES(29,1,5,'tests/data/zero1024.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,1024);
INSERT INTO entries VALUES(30,1,5,replace('tests/data/name\n.dat','\n',char(10)),1718326783,1718326783,1718326783,1000,1000,33204,0,NULL,1,12);
INSERT INTO entries VALUES(31,1,8,'tests/data/link.dat',1718417403,1718325625,1718325625,1000,1000,41471,0,NULL,1,0);
INSERT INTO entries VALUES(32,1,5,'tests/data/zero512k.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(33,1,5,'tests/data/random1024.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,1024);
INSERT INTO entries VALUES(34,1,5,'tests/data/readonly512k.dat',1718325625,1718325625,1718325625,1000,1000,33056,0,NULL,1,524288);
INSERT INTO entries VALUES(35,1,5,'tests/data/zero0.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,0);
INSERT INTO entries VALUES(36,1,5,'tests/data/name%d%f%s%p.dat',1718326783,1718326783,1718326783,1000,1000,33204,0,NULL,1,12);
INSERT INTO entries VALUES(37,1,7,'tests/data/sub_dir.ext',1718325625,1718325625,1718325625,1000,1000,16877,0,NULL,1,0);
INSERT INTO entries VALUES(38,1,7,'tests/data/sub_dir_extended_attribute',1718325625,1718325625,1718325625,1000,1000,16877,0,NULL,1,0);
INSERT INTO entries VALUES(39,1,7,'tests/data/delta1',1718325625,1718325625,1718325625,1000,1000,16877,0,NULL,1,0);
INSERT INTO entries VALUES(40,1,7,'tests/data/delta2',1718325625,1718325625,1718325625,1000,1000,16877,0,NULL,1,0);
INSERT INTO entries VALUES(41,1,5,'tests/data/smallfile.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,128);
INSERT INTO entries VALUES(42,1,5,'tests/data/sub_dir.ext/test.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,128);
INSERT INTO entries VALUES(43,1,7,'tests/data/sub_dir',1718325625,1718325625,1718325625,1000,1000,16877,0,NULL,1,0);
INSERT INTO entries VALUES(44,1,10,'tests/data/sub_dir/fifo',1718325625,1718325625,1718325625,1000,1000,4532,0,NULL,1,0);
INSERT INTO entries VALUES(45,1,8,'tests/data/sub_dir/link.dat',1718417403,1718325625,1718325625,1000,1000,41471,0,NULL,1,0);
INSERT INTO entries VALUES(46,1,5,'tests/data/sub_dir/test.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,128);
INSERT INTO entries VALUES(47,1,5,'tests/data/linkdata.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(48,1,5,'tests/data/zero-random512k.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(49,1,5,'tests/data/random512k.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(50,1,9,'tests/data/hardlink2.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(51,1,9,'tests/data/hardlink.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(52,1,9,'tests/data/hardlink1.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(53,1,5,'tests/data/delta2/random512k.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(54,1,5,'tests/data/delta1/random512k.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(55,1,9,'tests/data/delta2/hardlink2.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(56,1,9,'tests/data/delta2/hardlink.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(57,1,9,'tests/data/delta2/hardlink1.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(58,1,9,'tests/data/delta1/hardlink2.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(59,1,9,'tests/data/delta1/hardlink.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(60,1,9,'tests/data/delta1/hardlink1.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(61,1,5,'tests/data/sub_dir/linkdata.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(62,1,9,'tests/data/sub_dir/hardlink2.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(63,1,9,'tests/data/sub_dir/hardlink.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
INSERT INTO entries VALUES(64,1,9,'tests/data/sub_dir/hardlink1.dat',1718325625,1718325625,1718325625,1000,1000,33204,0,NULL,1,524288);
CREATE TABLE entriesNewest (  id              INTEGER PRIMARY KEY,   entryId         INTEGER REFERENCES entries(id) ON DELETE CASCADE,   uuidId          INTEGER DEFAULT 0,   entityId        INTEGER DEFAULT 0,   type            INTEGER DEFAULT 0,   name            TEXT NOT NULL,   timeLastChanged INTEGER DEFAULT 0,   userId          INTEGER DEFAULT 0,   groupId         INTEGER DEFAULT 0,   permission      INTEGER DEFAULT 0,   size            INTEGER DEFAULT 0,   CONSTRAINT entriesNewest UNIQUE (name) );
INSERT INTO entriesNewest VALUES(1,7,1,1,5,'tests/data/zero128.dat',1718417638,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(2,10,1,1,5,'tests/data/random128.dat',1718417638,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(3,9,1,1,5,'tests/data/encodingCP1252-',1718417634,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(4,23,1,1,5,'tests/data/encodingUTF8-äöüÄÖÜß',1718417634,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(5,1,1,1,7,'tests/data',1718326783,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(6,5,1,1,5,'tests/data/name".dat',1718326783,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(7,26,1,1,5,'tests/data/name\.dat',1718326783,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(8,28,1,1,5,'tests/data/name''.dat',1718326783,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(9,30,1,1,5,replace('tests/data/name\n.dat','\n',char(10)),1718326783,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(10,36,1,1,5,'tests/data/name%d%f%s%p.dat',1718326783,1000,1000,33204,12);
INSERT INTO entriesNewest VALUES(11,2,1,1,10,'tests/data/fifo.ext',1718325625,1000,1000,4532,0);
INSERT INTO entriesNewest VALUES(12,3,1,1,5,'tests/data/file400.dat',1718325625,1000,1000,33024,1024);
INSERT INTO entriesNewest VALUES(13,4,1,1,5,'tests/data/file664.dat',1718325625,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(14,6,1,1,5,'tests/data/extended_attribute.dat',1718325625,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(15,8,1,1,5,'tests/data/immutable.dat',1718325625,1000,1000,33204,18);
INSERT INTO entriesNewest VALUES(16,11,1,1,9,'tests/data/hardlink_extended_attribute.dat',1718325625,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(17,12,1,1,9,'tests/data/hardlinkdata_extended_attribute.dat',1718325625,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(18,13,1,1,10,'tests/data/fifo',1718325625,1000,1000,4532,0);
INSERT INTO entriesNewest VALUES(19,14,1,1,5,'tests/data/sparse.dat',1718325625,1000,1000,33204,196608);
INSERT INTO entriesNewest VALUES(20,15,1,1,5,'tests/data/readonly.dat',1718325625,1000,1000,33056,12);
INSERT INTO entriesNewest VALUES(21,16,1,1,8,'tests/data/link_not_existing_file.dat',1718325625,1000,1000,41471,0);
INSERT INTO entriesNewest VALUES(22,17,1,1,8,'tests/data/circular_link.dat',1718325625,1000,1000,41471,0);
INSERT INTO entriesNewest VALUES(23,18,1,1,5,'tests/data/file666.dat',1718325625,1000,1000,33206,1024);
INSERT INTO entriesNewest VALUES(24,19,1,1,5,'tests/data/circular_link.dat.marker',1718325625,1000,1000,33204,0);
INSERT INTO entriesNewest VALUES(25,20,1,1,10,'tests/data/character_device',1718325625,0,0,8614,0);
INSERT INTO entriesNewest VALUES(26,21,1,1,10,'tests/data/block_device',1718325625,0,0,24998,0);
INSERT INTO entriesNewest VALUES(27,22,1,1,5,'tests/data/file_big_group_id.dat',1718325625,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(28,24,1,1,5,'tests/data/file640.dat',1718325625,1000,1000,33184,1024);
INSERT INTO entriesNewest VALUES(29,25,1,1,5,'tests/data/file644.dat',1718325625,1000,1000,33188,1024);
INSERT INTO entriesNewest VALUES(30,27,1,1,5,'tests/data/append-only.dat',1718325625,1000,1000,33204,17);
INSERT INTO entriesNewest VALUES(31,29,1,1,5,'tests/data/zero1024.dat',1718325625,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(32,31,1,1,8,'tests/data/link.dat',1718325625,1000,1000,41471,0);
INSERT INTO entriesNewest VALUES(33,32,1,1,5,'tests/data/zero512k.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(34,33,1,1,5,'tests/data/random1024.dat',1718325625,1000,1000,33204,1024);
INSERT INTO entriesNewest VALUES(35,34,1,1,5,'tests/data/readonly512k.dat',1718325625,1000,1000,33056,524288);
INSERT INTO entriesNewest VALUES(36,35,1,1,5,'tests/data/zero0.dat',1718325625,1000,1000,33204,0);
INSERT INTO entriesNewest VALUES(37,37,1,1,7,'tests/data/sub_dir.ext',1718325625,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(38,38,1,1,7,'tests/data/sub_dir_extended_attribute',1718325625,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(39,39,1,1,7,'tests/data/delta1',1718325625,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(40,40,1,1,7,'tests/data/delta2',1718325625,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(41,41,1,1,5,'tests/data/smallfile.dat',1718325625,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(42,42,1,1,5,'tests/data/sub_dir.ext/test.dat',1718325625,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(43,43,1,1,7,'tests/data/sub_dir',1718325625,1000,1000,16877,0);
INSERT INTO entriesNewest VALUES(44,44,1,1,10,'tests/data/sub_dir/fifo',1718325625,1000,1000,4532,0);
INSERT INTO entriesNewest VALUES(45,45,1,1,8,'tests/data/sub_dir/link.dat',1718325625,1000,1000,41471,0);
INSERT INTO entriesNewest VALUES(46,46,1,1,5,'tests/data/sub_dir/test.dat',1718325625,1000,1000,33204,128);
INSERT INTO entriesNewest VALUES(47,47,1,1,5,'tests/data/linkdata.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(48,48,1,1,5,'tests/data/zero-random512k.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(49,49,1,1,5,'tests/data/random512k.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(50,50,1,1,9,'tests/data/hardlink2.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(51,51,1,1,9,'tests/data/hardlink.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(52,52,1,1,9,'tests/data/hardlink1.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(53,53,1,1,5,'tests/data/delta2/random512k.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(54,54,1,1,5,'tests/data/delta1/random512k.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(55,55,1,1,9,'tests/data/delta2/hardlink2.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(56,56,1,1,9,'tests/data/delta2/hardlink.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(57,57,1,1,9,'tests/data/delta2/hardlink1.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(58,58,1,1,9,'tests/data/delta1/hardlink2.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(59,59,1,1,9,'tests/data/delta1/hardlink.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(60,60,1,1,9,'tests/data/delta1/hardlink1.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(61,61,1,1,5,'tests/data/sub_dir/linkdata.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(62,62,1,1,9,'tests/data/sub_dir/hardlink2.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(63,63,1,1,9,'tests/data/sub_dir/hardlink.dat',1718325625,1000,1000,33204,524288);
INSERT INTO entriesNewest VALUES(64,64,1,1,9,'tests/data/sub_dir/hardlink1.dat',1718325625,1000,1000,33204,524288);
INSERT INTO sqlite_schema(type,name,tbl_name,rootpage,sql)VALUES('table','FTS_entries','FTS_entries',0,'CREATE VIRTUAL TABLE FTS_entries USING FTS5(  entryId,   name,   tokenize=unicode61 )');
CREATE TABLE IF NOT EXISTS 'FTS_entries_data'(id INTEGER PRIMARY KEY, block BLOB);
INSERT INTO FTS_entries_data VALUES(1,X'40408229');
INSERT INTO FTS_entries_data VALUES(10,X'000000000101010001010101');
INSERT INTO FTS_entries_data VALUES(137438953473,X'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');
CREATE TABLE IF NOT EXISTS 'FTS_entries_idx'(segid, term, pgno, PRIMARY KEY(segid, term)) WITHOUT ROWID;
INSERT INTO FTS_entries_idx VALUES(1,X'',2);
CREATE TABLE IF NOT EXISTS 'FTS_entries_content'(id INTEGER PRIMARY KEY, c0, c1);
INSERT INTO FTS_entries_content VALUES(1,1,'tests/data');
INSERT INTO FTS_entries_content VALUES(2,2,'tests/data/fifo.ext');
INSERT INTO FTS_entries_content VALUES(3,3,'tests/data/file400.dat');
INSERT INTO FTS_entries_content VALUES(4,4,'tests/data/file664.dat');
INSERT INTO FTS_entries_content VALUES(5,5,'tests/data/name".dat');
INSERT INTO FTS_entries_content VALUES(6,6,'tests/data/extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(7,7,'tests/data/zero128.dat');
INSERT INTO FTS_entries_content VALUES(8,8,'tests/data/immutable.dat');
INSERT INTO FTS_entries_content VALUES(9,9,'tests/data/encodingCP1252-');
INSERT INTO FTS_entries_content VALUES(10,10,'tests/data/random128.dat');
INSERT INTO FTS_entries_content VALUES(11,11,'tests/data/hardlink_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(12,12,'tests/data/hardlinkdata_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(13,13,'tests/data/fifo');
INSERT INTO FTS_entries_content VALUES(14,14,'tests/data/sparse.dat');
INSERT INTO FTS_entries_content VALUES(15,15,'tests/data/readonly.dat');
INSERT INTO FTS_entries_content VALUES(16,16,'tests/data/link_not_existing_file.dat');
INSERT INTO FTS_entries_content VALUES(17,17,'tests/data/circular_link.dat');
INSERT INTO FTS_entries_content VALUES(18,18,'tests/data/file666.dat');
INSERT INTO FTS_entries_content VALUES(19,19,'tests/data/circular_link.dat.marker');
INSERT INTO FTS_entries_content VALUES(20,20,'tests/data/character_device');
INSERT INTO FTS_entries_content VALUES(21,21,'tests/data/block_device');
INSERT INTO FTS_entries_content VALUES(22,22,'tests/data/file_big_group_id.dat');
INSERT INTO FTS_entries_content VALUES(23,23,'tests/data/encodingUTF8-äöüÄÖÜß');
INSERT INTO FTS_entries_content VALUES(24,24,'tests/data/file640.dat');
INSERT INTO FTS_entries_content VALUES(25,25,'tests/data/file644.dat');
INSERT INTO FTS_entries_content VALUES(26,26,'tests/data/name\.dat');
INSERT INTO FTS_entries_content VALUES(27,27,'tests/data/append-only.dat');
INSERT INTO FTS_entries_content VALUES(28,28,'tests/data/name''.dat');
INSERT INTO FTS_entries_content VALUES(29,29,'tests/data/zero1024.dat');
INSERT INTO FTS_entries_content VALUES(30,30,replace('tests/data/name\n.dat','\n',char(10)));
INSERT INTO FTS_entries_content VALUES(31,31,'tests/data/link.dat');
INSERT INTO FTS_entries_content VALUES(32,32,'tests/data/zero512k.dat');
INSERT INTO FTS_entries_content VALUES(33,33,'tests/data/random1024.dat');
INSERT INTO FTS_entries_content VALUES(34,34,'tests/data/readonly512k.dat');
INSERT INTO FTS_entries_content VALUES(35,35,'tests/data/zero0.dat');
INSERT INTO FTS_entries_content VALUES(36,36,'tests/data/name%d%f%s%p.dat');
INSERT INTO FTS_entries_content VALUES(37,37,'tests/data/sub_dir.ext');
INSERT INTO FTS_entries_content VALUES(38,38,'tests/data/sub_dir_extended_attribute');
INSERT INTO FTS_entries_content VALUES(39,39,'tests/data/delta1');
INSERT INTO FTS_entries_content VALUES(40,40,'tests/data/delta2');
INSERT INTO FTS_entries_content VALUES(41,41,'tests/data/smallfile.dat');
INSERT INTO FTS_entries_content VALUES(42,42,'tests/data/sub_dir.ext/test.dat');
INSERT INTO FTS_entries_content VALUES(43,43,'tests/data/sub_dir');
INSERT INTO FTS_entries_content VALUES(44,44,'tests/data/sub_dir/fifo');
INSERT INTO FTS_entries_content VALUES(45,45,'tests/data/sub_dir/link.dat');
INSERT INTO FTS_entries_content VALUES(46,46,'tests/data/sub_dir/test.dat');
INSERT INTO FTS_entries_content VALUES(47,47,'tests/data/linkdata.dat');
INSERT INTO FTS_entries_content VALUES(48,48,'tests/data/zero-random512k.dat');
INSERT INTO FTS_entries_content VALUES(49,49,'tests/data/random512k.dat');
INSERT INTO FTS_entries_content VALUES(50,50,'tests/data/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(51,51,'tests/data/hardlink.dat');
INSERT INTO FTS_entries_content VALUES(52,52,'tests/data/hardlink1.dat');
INSERT INTO FTS_entries_content VALUES(53,53,'tests/data/delta2/random512k.dat');
INSERT INTO FTS_entries_content VALUES(54,54,'tests/data/delta1/random512k.dat');
INSERT INTO FTS_entries_content VALUES(55,55,'tests/data/delta2/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(56,56,'tests/data/delta2/hardlink.dat');
INSERT INTO FTS_entries_content VALUES(57,57,'tests/data/delta2/hardlink1.dat');
INSERT INTO FTS_entries_content VALUES(58,58,'tests/data/delta1/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(59,59,'tests/data/delta1/hardlink.dat');
INSERT INTO FTS_entries_content VALUES(60,60,'tests/data/delta1/hardlink1.dat');
INSERT INTO FTS_entries_content VALUES(61,61,'tests/data/sub_dir/linkdata.dat');
INSERT INTO FTS_entries_content VALUES(62,62,'tests/data/sub_dir/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(63,63,'tests/data/sub_dir/hardlink.dat');
INSERT INTO FTS_entries_content VALUES(64,64,'tests/data/sub_dir/hardlink1.dat');
CREATE TABLE IF NOT EXISTS 'FTS_entries_docsize'(id INTEGER PRIMARY KEY, sz BLOB);
INSERT INTO FTS_entries_docsize VALUES(1,X'0102');
INSERT INTO FTS_entries_docsize VALUES(2,X'0104');
INSERT INTO FTS_entries_docsize VALUES(3,X'0104');
INSERT INTO FTS_entries_docsize VALUES(4,X'0104');
INSERT INTO FTS_entries_docsize VALUES(5,X'0104');
INSERT INTO FTS_entries_docsize VALUES(6,X'0105');
INSERT INTO FTS_entries_docsize VALUES(7,X'0104');
INSERT INTO FTS_entries_docsize VALUES(8,X'0104');
INSERT INTO FTS_entries_docsize VALUES(9,X'0103');
INSERT INTO FTS_entries_docsize VALUES(10,X'0104');
INSERT INTO FTS_entries_docsize VALUES(11,X'0106');
INSERT INTO FTS_entries_docsize VALUES(12,X'0106');
INSERT INTO FTS_entries_docsize VALUES(13,X'0103');
INSERT INTO FTS_entries_docsize VALUES(14,X'0104');
INSERT INTO FTS_entries_docsize VALUES(15,X'0104');
INSERT INTO FTS_entries_docsize VALUES(16,X'0107');
INSERT INTO FTS_entries_docsize VALUES(17,X'0105');
INSERT INTO FTS_entries_docsize VALUES(18,X'0104');
INSERT INTO FTS_entries_docsize VALUES(19,X'0106');
INSERT INTO FTS_entries_docsize VALUES(20,X'0104');
INSERT INTO FTS_entries_docsize VALUES(21,X'0104');
INSERT INTO FTS_entries_docsize VALUES(22,X'0107');
INSERT INTO FTS_entries_docsize VALUES(23,X'0104');
INSERT INTO FTS_entries_docsize VALUES(24,X'0104');
INSERT INTO FTS_entries_docsize VALUES(25,X'0104');
INSERT INTO FTS_entries_docsize VALUES(26,X'0104');
INSERT INTO FTS_entries_docsize VALUES(27,X'0105');
INSERT INTO FTS_entries_docsize VALUES(28,X'0104');
INSERT INTO FTS_entries_docsize VALUES(29,X'0104');
INSERT INTO FTS_entries_docsize VALUES(30,X'0104');
INSERT INTO FTS_entries_docsize VALUES(31,X'0104');
INSERT INTO FTS_entries_docsize VALUES(32,X'0104');
INSERT INTO FTS_entries_docsize VALUES(33,X'0104');
INSERT INTO FTS_entries_docsize VALUES(34,X'0104');
INSERT INTO FTS_entries_docsize VALUES(35,X'0104');
INSERT INTO FTS_entries_docsize VALUES(36,X'0108');
INSERT INTO FTS_entries_docsize VALUES(37,X'0105');
INSERT INTO FTS_entries_docsize VALUES(38,X'0106');
INSERT INTO FTS_entries_docsize VALUES(39,X'0103');
INSERT INTO FTS_entries_docsize VALUES(40,X'0103');
INSERT INTO FTS_entries_docsize VALUES(41,X'0104');
INSERT INTO FTS_entries_docsize VALUES(42,X'0107');
INSERT INTO FTS_entries_docsize VALUES(43,X'0104');
INSERT INTO FTS_entries_docsize VALUES(44,X'0105');
INSERT INTO FTS_entries_docsize VALUES(45,X'0106');
INSERT INTO FTS_entries_docsize VALUES(46,X'0106');
INSERT INTO FTS_entries_docsize VALUES(47,X'0104');
INSERT INTO FTS_entries_docsize VALUES(48,X'0105');
INSERT INTO FTS_entries_docsize VALUES(49,X'0104');
INSERT INTO FTS_entries_docsize VALUES(50,X'0104');
INSERT INTO FTS_entries_docsize VALUES(51,X'0104');
INSERT INTO FTS_entries_docsize VALUES(52,X'0104');
INSERT INTO FTS_entries_docsize VALUES(53,X'0105');
INSERT INTO FTS_entries_docsize VALUES(54,X'0105');
INSERT INTO FTS_entries_docsize VALUES(55,X'0105');
INSERT INTO FTS_entries_docsize VALUES(56,X'0105');
INSERT INTO FTS_entries_docsize VALUES(57,X'0105');
INSERT INTO FTS_entries_docsize VALUES(58,X'0105');
INSERT INTO FTS_entries_docsize VALUES(59,X'0105');
INSERT INTO FTS_entries_docsize VALUES(60,X'0105');
INSERT INTO FTS_entries_docsize VALUES(61,X'0106');
INSERT INTO FTS_entries_docsize VALUES(62,X'0106');
INSERT INTO FTS_entries_docsize VALUES(63,X'0106');
INSERT INTO FTS_entries_docsize VALUES(64,X'0106');
CREATE TABLE IF NOT EXISTS 'FTS_entries_config'(k PRIMARY KEY, v) WITHOUT ROWID;
INSERT INTO FTS_entries_config VALUES('version',4);
CREATE TABLE skippedEntries (  id          INTEGER PRIMARY KEY,   entityId    INTEGER NOT NULL REFERENCES entities(id),   name        TEXT NOT NULL,   type        INTEGER,   deletedFlag INTEGER DEFAULT 0 );
CREATE TABLE entryFragments (  id        INTEGER PRIMARY KEY,   entryId   INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   offset    INTEGER,   size      INTEGER );
INSERT INTO entryFragments VALUES(1,3,1,0,1024);
INSERT INTO entryFragments VALUES(2,4,1,0,1024);
INSERT INTO entryFragments VALUES(3,5,1,0,12);
INSERT INTO entryFragments VALUES(4,6,1,0,1024);
INSERT INTO entryFragments VALUES(5,7,1,0,128);
INSERT INTO entryFragments VALUES(6,8,1,0,18);
INSERT INTO entryFragments VALUES(7,9,1,0,12);
INSERT INTO entryFragments VALUES(8,10,1,0,128);
INSERT INTO entryFragments VALUES(9,11,1,0,1024);
INSERT INTO entryFragments VALUES(10,12,1,0,1024);
INSERT INTO entryFragments VALUES(11,14,1,0,196608);
INSERT INTO entryFragments VALUES(12,15,1,0,12);
INSERT INTO entryFragments VALUES(13,18,1,0,1024);
INSERT INTO entryFragments VALUES(14,19,1,0,0);
INSERT INTO entryFragments VALUES(15,22,1,0,1024);
INSERT INTO entryFragments VALUES(16,23,1,0,12);
INSERT INTO entryFragments VALUES(17,24,1,0,1024);
INSERT INTO entryFragments VALUES(18,25,1,0,1024);
INSERT INTO entryFragments VALUES(19,26,1,0,12);
INSERT INTO entryFragments VALUES(20,27,1,0,17);
INSERT INTO entryFragments VALUES(21,28,1,0,12);
INSERT INTO entryFragments VALUES(22,29,1,0,1024);
INSERT INTO entryFragments VALUES(23,30,1,0,12);
INSERT INTO entryFragments VALUES(24,32,1,0,524288);
INSERT INTO entryFragments VALUES(25,33,1,0,1024);
INSERT INTO entryFragments VALUES(26,34,1,0,524288);
INSERT INTO entryFragments VALUES(27,35,1,0,0);
INSERT INTO entryFragments VALUES(28,36,1,0,12);
INSERT INTO entryFragments VALUES(29,41,1,0,128);
INSERT INTO entryFragments VALUES(30,42,1,0,128);
INSERT INTO entryFragments VALUES(31,46,1,0,128);
INSERT INTO entryFragments VALUES(32,47,1,0,524288);
INSERT INTO entryFragments VALUES(33,48,1,0,524288);
INSERT INTO entryFragments VALUES(34,49,1,0,524288);
INSERT INTO entryFragments VALUES(35,50,1,0,524288);
INSERT INTO entryFragments VALUES(36,51,1,0,524288);
INSERT INTO entryFragments VALUES(37,52,1,0,524288);
INSERT INTO entryFragments VALUES(38,53,1,0,524288);
INSERT INTO entryFragments VALUES(39,54,1,0,524288);
INSERT INTO entryFragments VALUES(40,55,1,0,524288);
INSERT INTO entryFragments VALUES(41,56,1,0,524288);
INSERT INTO entryFragments VALUES(42,57,1,0,524288);
INSERT INTO entryFragments VALUES(43,58,1,0,524288);
INSERT INTO entryFragments VALUES(44,59,1,0,524288);
INSERT INTO entryFragments VALUES(45,60,1,0,524288);
INSERT INTO entryFragments VALUES(46,61,1,0,524288);
INSERT INTO entryFragments VALUES(47,62,1,0,524288);
INSERT INTO entryFragments VALUES(48,63,1,0,524288);
INSERT INTO entryFragments VALUES(49,64,1,0,524288);
CREATE TABLE fileEntries (  id              INTEGER PRIMARY KEY,   entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   size            INTEGER,   CONSTRAINT fileEntries UNIQUE (entryId) );
INSERT INTO fileEntries VALUES(1,3,1024);
INSERT INTO fileEntries VALUES(2,4,1024);
INSERT INTO fileEntries VALUES(3,5,12);
INSERT INTO fileEntries VALUES(4,6,1024);
INSERT INTO fileEntries VALUES(5,7,128);
INSERT INTO fileEntries VALUES(6,8,18);
INSERT INTO fileEntries VALUES(7,9,12);
INSERT INTO fileEntries VALUES(8,10,128);
INSERT INTO fileEntries VALUES(9,14,196608);
INSERT INTO fileEntries VALUES(10,15,12);
INSERT INTO fileEntries VALUES(11,18,1024);
INSERT INTO fileEntries VALUES(12,19,0);
INSERT INTO fileEntries VALUES(13,22,1024);
INSERT INTO fileEntries VALUES(14,23,12);
INSERT INTO fileEntries VALUES(15,24,1024);
INSERT INTO fileEntries VALUES(16,25,1024);
INSERT INTO fileEntries VALUES(17,26,12);
INSERT INTO fileEntries VALUES(18,27,17);
INSERT INTO fileEntries VALUES(19,28,12);
INSERT INTO fileEntries VALUES(20,29,1024);
INSERT INTO fileEntries VALUES(21,30,12);
INSERT INTO fileEntries VALUES(22,32,524288);
INSERT INTO fileEntries VALUES(23,33,1024);
INSERT INTO fileEntries VALUES(24,34,524288);
INSERT INTO fileEntries VALUES(25,35,0);
INSERT INTO fileEntries VALUES(26,36,12);
INSERT INTO fileEntries VALUES(27,41,128);
INSERT INTO fileEntries VALUES(28,42,128);
INSERT INTO fileEntries VALUES(29,46,128);
INSERT INTO fileEntries VALUES(30,47,524288);
INSERT INTO fileEntries VALUES(31,48,524288);
INSERT INTO fileEntries VALUES(32,49,524288);
INSERT INTO fileEntries VALUES(33,53,524288);
INSERT INTO fileEntries VALUES(34,54,524288);
INSERT INTO fileEntries VALUES(35,61,524288);
CREATE TABLE imageEntries (  id             INTEGER PRIMARY KEY,   entryId        INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   size           INTEGER,   fileSystemType INTEGER,   blockSize      INTEGER,   CONSTRAINT imageEntries UNIQUE (entryId) );
CREATE TABLE directoryEntries (  id                    INTEGER PRIMARY KEY,   entryId               INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId             INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   name                  TEXT,   CONSTRAINT directoryEntries UNIQUE (entryId) );
INSERT INTO directoryEntries VALUES(1,1,1,'tests/data');
INSERT INTO directoryEntries VALUES(2,37,1,'tests/data/sub_dir.ext');
INSERT INTO directoryEntries VALUES(3,38,1,'tests/data/sub_dir_extended_attribute');
INSERT INTO directoryEntries VALUES(4,39,1,'tests/data/delta1');
INSERT INTO directoryEntries VALUES(5,40,1,'tests/data/delta2');
INSERT INTO directoryEntries VALUES(6,43,1,'tests/data/sub_dir');
CREATE TABLE linkEntries (  id              INTEGER PRIMARY KEY,   entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId       INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   destinationName TEXT,   CONSTRAINT linkEntries UNIQUE (entryId) );
INSERT INTO linkEntries VALUES(1,16,1,'not-existing-file');
INSERT INTO linkEntries VALUES(2,17,1,'circular_link.dat');
INSERT INTO linkEntries VALUES(3,31,1,'linkdata.dat');
INSERT INTO linkEntries VALUES(4,45,1,'linkdata.dat');
CREATE TABLE hardlinkEntries (  id      INTEGER PRIMARY KEY,   entryId INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   size    INTEGER,   CONSTRAINT hardlinkEntries UNIQUE (entryId) );
INSERT INTO hardlinkEntries VALUES(1,11,1024);
INSERT INTO hardlinkEntries VALUES(2,12,1024);
INSERT INTO hardlinkEntries VALUES(3,50,524288);
INSERT INTO hardlinkEntries VALUES(4,51,524288);
INSERT INTO hardlinkEntries VALUES(5,52,524288);
INSERT INTO hardlinkEntries VALUES(6,55,524288);
INSERT INTO hardlinkEntries VALUES(7,56,524288);
INSERT INTO hardlinkEntries VALUES(8,57,524288);
INSERT INTO hardlinkEntries VALUES(9,58,524288);
INSERT INTO hardlinkEntries VALUES(10,59,524288);
INSERT INTO hardlinkEntries VALUES(11,60,524288);
INSERT INTO hardlinkEntries VALUES(12,62,524288);
INSERT INTO hardlinkEntries VALUES(13,63,524288);
INSERT INTO hardlinkEntries VALUES(14,64,524288);
CREATE TABLE specialEntries (  id          INTEGER PRIMARY KEY,   entryId     INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,   storageId   INTEGER NOT NULL REFERENCES storages(id) ON DELETE CASCADE,   specialType INTEGER,   major       INTEGER,   minor       INTEGER,   CONSTRAINT specialEntries UNIQUE (entryId) );
INSERT INTO specialEntries VALUES(1,2,1,2,0,0);
INSERT INTO specialEntries VALUES(2,13,1,2,0,0);
INSERT INTO specialEntries VALUES(3,20,1,0,1,2);
INSERT INTO specialEntries VALUES(4,21,1,1,3,4);
INSERT INTO specialEntries VALUES(5,44,1,2,0,0);
CREATE TABLE history (  id                INTEGER PRIMARY KEY,   jobUUID           TEXT NOT NULL,   scheduleUUID      TEXT,   hostName          TEXT,   userName          TEXT,   type              INTEGER,   created           INTEGER,   errorMessage      TEXT,   duration          INTEGER,   totalEntryCount   INTEGER,   totalEntrySize    INTEGER,   skippedEntryCount INTEGER,   skippedEntrySize  INTEGER,   errorEntryCount   INTEGER,   errorEntrySize    INTEGER );
INSERT INTO history VALUES(1,'daa50cfb-5ada-4f65-ae9d-75ba194cc52d','a9a71610-cb3f-4908-8a69-c260a92ac663','tooku',NULL,1,1718419088,NULL,1,56,6499087,2,1036,0,0);
CREATE TABLE log (  text TEXT );
CREATE INDEX bar_index4 ON uuids (jobUUID);
CREATE INDEX bar_index5 ON entities (jobUUID,created,type);
CREATE INDEX bar_index6 ON entities (hostName);
CREATE INDEX bar_index7 ON entities (deletedFlag);
CREATE TRIGGER bar_trigger9 INSERT ON entities BEGIN  INSERT OR IGNORE INTO uuids     (jobUUID) VALUES (NEW.jobUUID);END;
CREATE INDEX bar_index10 ON storages (uuidId,entityId,name,created,state);
CREATE INDEX bar_index11 ON storages (entityId,name,created,state);
CREATE INDEX bar_index12 ON storages (name,totalEntryCount,created,state);
CREATE INDEX bar_index13 ON storages (created,name,totalEntryCount,state);
CREATE INDEX bar_index14 ON storages (userName);
CREATE INDEX bar_index15 ON storages (state,name,totalEntryCount,created);
CREATE INDEX bar_index16 ON storages (deletedFlag);
CREATE INDEX bar_index17 ON entries (uuidId,entityId,type,name);
CREATE INDEX bar_index18 ON entries (entityId,type,name);
CREATE INDEX bar_index19 ON entries (name,size,type,timeLastChanged);
CREATE INDEX bar_index20 ON entries (type,size,name,timeLastChanged);
CREATE INDEX bar_index21 ON entries (size,type,name,timeLastChanged);
CREATE INDEX bar_index22 ON entries (timeLastChanged,name,size,type);
CREATE INDEX bar_index23 ON entriesNewest (entryId,name,size,timeLastChanged);
CREATE INDEX bar_index24 ON entriesNewest (name,size,type,timeLastChanged);
CREATE INDEX bar_index25 ON entriesNewest (type,entryId,name,size,timeLastChanged);
CREATE INDEX bar_index26 ON entriesNewest (type,size,name,timeLastChanged);
CREATE INDEX bar_index27 ON entriesNewest (size,type,name,timeLastChanged);
CREATE INDEX bar_index28 ON entriesNewest (timeLastChanged,name,size,type);
CREATE INDEX bar_index29 ON entriesNewest (entityId,type,entryId,name,size,timeLastChanged);
CREATE INDEX bar_index30 ON skippedEntries (entityId,type,name);
CREATE INDEX bar_index31 ON skippedEntries (name);
CREATE INDEX bar_index32 ON skippedEntries (type,name);
CREATE INDEX bar_index33 ON entryFragments (entryId);
CREATE INDEX bar_index34 ON entryFragments (storageId);
CREATE INDEX bar_index35 ON fileEntries (entryId);
CREATE INDEX bar_index36 ON imageEntries (entryId);
CREATE INDEX bar_index37 ON directoryEntries (entryId);
CREATE INDEX bar_index38 ON directoryEntries (storageId,name);
CREATE INDEX bar_index39 ON directoryEntries (name);
CREATE INDEX bar_index40 ON linkEntries (entryId);
CREATE INDEX bar_index41 ON linkEntries (storageId);
CREATE INDEX bar_index42 ON hardlinkEntries (entryId);
CREATE INDEX bar_index43 ON specialEntries (entryId);
CREATE INDEX bar_index44 ON specialEntries (storageId);
CREATE INDEX bar_index45 ON history (jobUUID,created,type);
CREATE INDEX bar_index46 ON history (created);
CREATE INDEX bar_index47 ON history (errorMessage);
PRAGMA writable_schema=OFF;
COMMIT;
