PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE meta(  name  TEXT UNIQUE,  value TEXT);
INSERT INTO meta VALUES('version','6');
INSERT INTO meta VALUES('datetime','2019-09-28 07:48:30');
CREATE TABLE uuids(  id                  INTEGER PRIMARY KEY,  jobUUID             TEXT UNIQUE NOT NULL);
INSERT INTO uuids VALUES(1,'8501b352-250f-4a45-877c-569b9e322681');
CREATE TABLE entities(  id                  INTEGER PRIMARY KEY,  jobUUID             TEXT NOT NULL,  scheduleUUID        TEXT NOT NULL DEFAULT '',  created             INTEGER,  type                INTEGER,  parentJobUUID       INTEGER,  bidFlag             INTEGER,  lockedFlag          INTEGER,  comment             TEXT);
INSERT INTO entities VALUES(0,'','',0,0,0,0,0,NULL);
INSERT INTO entities VALUES(1,'8501b352-250f-4a45-877c-569b9e322681','',1569656974,2,'',0,NULL,NULL);
INSERT INTO entities VALUES(2,'8501b352-250f-4a45-877c-569b9e322681','',1569656987,2,'',0,NULL,NULL);
CREATE TABLE storage(  id                        INTEGER PRIMARY KEY,  entityId                  INTEGER NOT NULL REFERENCES entities(id) ON DELETE CASCADE,  name                      TEXT NOT NULL,  created                   INTEGER,  size                      INTEGER DEFAULT 0,  state                     INTEGER DEFAULT 2,  mode                      INTEGER DEFAULT 0,  lastChecked               INTEGER DEFAULT 0,  errorMessage              TEXT,  totalEntryCount           INTEGER DEFAULT 0,    totalEntrySize            INTEGER DEFAULT 0,    totalFileCount            INTEGER DEFAULT 0,    totalFileSize             INTEGER DEFAULT 0,    totalImageCount           INTEGER DEFAULT 0,    totalImageSize            INTEGER DEFAULT 0,    totalDirectoryCount       INTEGER DEFAULT 0,    totalLinkCount            INTEGER DEFAULT 0,    totalHardlinkCount        INTEGER DEFAULT 0,    totalHardlinkSize         INTEGER DEFAULT 0,    totalSpecialCount         INTEGER DEFAULT 0,    totalEntryCountNewest     INTEGER DEFAULT 0,    totalEntrySizeNewest      INTEGER DEFAULT 0,    totalFileCountNewest      INTEGER DEFAULT 0,    totalFileSizeNewest       INTEGER DEFAULT 0,    totalImageCountNewest     INTEGER DEFAULT 0,    totalImageSizeNewest      INTEGER DEFAULT 0,    totalDirectoryCountNewest INTEGER DEFAULT 0,    totalLinkCountNewest      INTEGER DEFAULT 0,    totalHardlinkCountNewest  INTEGER DEFAULT 0,    totalHardlinkSizeNewest   INTEGER DEFAULT 0,    totalSpecialCountNewest   INTEGER DEFAULT 0   );
INSERT INTO storage VALUES(1,1,'','2019-09-28 07:49:34',0,6,1,'2019-09-28 07:49:34',NULL,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
INSERT INTO storage VALUES(2,2,'test.bar','2019-09-28 07:49:47',4209682,1,1,'2019-09-28 07:49:47',NULL,43,5253623,34,5253623,0,0,5,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0);
PRAGMA writable_schema=ON;
INSERT INTO sqlite_master(type,name,tbl_name,rootpage,sql)VALUES('table','FTS_storage','FTS_storage',0,'CREATE VIRTUAL TABLE FTS_storage USING FTS4(  storageId,  name,  tokenize=unicode61)');
CREATE TABLE IF NOT EXISTS 'FTS_storage_content'(docid INTEGER PRIMARY KEY, 'c0storageId', 'c1name');
INSERT INTO FTS_storage_content VALUES(1,1,'');
INSERT INTO FTS_storage_content VALUES(2,2,'test.bar');
CREATE TABLE IF NOT EXISTS 'FTS_storage_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'FTS_storage_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
INSERT INTO FTS_storage_segdir VALUES(0,0,0,0,'0 7',X'00013103010200');
INSERT INTO FTS_storage_segdir VALUES(0,1,0,0,'0 7',X'00013203020200');
INSERT INTO FTS_storage_segdir VALUES(0,2,0,0,'0 30',X'000132030202000003626172050201010300000474657374050201010200');
CREATE TABLE IF NOT EXISTS 'FTS_storage_docsize'(docid INTEGER PRIMARY KEY, size BLOB);
INSERT INTO FTS_storage_docsize VALUES(1,X'0100');
INSERT INTO FTS_storage_docsize VALUES(2,X'0102');
CREATE TABLE IF NOT EXISTS 'FTS_storage_stat'(id INTEGER PRIMARY KEY, value BLOB);
INSERT INTO FTS_storage_stat VALUES(0,X'0202020a');
CREATE TABLE entries(  id              INTEGER PRIMARY KEY,  storageId       INTEGER NOT NULL REFERENCES storage(id) ON DELETE CASCADE,  name            TEXT NOT NULL,  type            INTEGER,  timeLastAccess  INTEGER,  timeModified    INTEGER,  timeLastChanged INTEGER,  userId          INTEGER,  groupId         INTEGER,  permission      INTEGER,  offset          INTEGER DEFAULT 0,    size            INTEGER DEFAULT 0   );
INSERT INTO entries VALUES(1,1,'test/data',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(2,1,'test/data/fifo',10,1569148357,1569148357,1569148357,1000,1000,4532,0,0);
INSERT INTO entries VALUES(3,1,'test/data/file664.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(4,1,'test/data/file666.dat',5,1569566935,1569148356,1569148356,1000,1000,33206,0,1024);
INSERT INTO entries VALUES(5,1,'test/data/circular_link.dat.marker',5,1569653032,1569148356,1569148356,1000,1000,33204,0,0);
INSERT INTO entries VALUES(6,1,'test/data/link_not_existing_file.dat',8,1569656784,1569148356,1569148356,1000,1000,41471,0,0);
INSERT INTO entries VALUES(7,1,'test/data/circular_link.dat',8,1569656784,1569148356,1569148356,1000,1000,41471,0,0);
INSERT INTO entries VALUES(8,1,'test/data/zero.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,0);
INSERT INTO entries VALUES(9,1,'test/data/name\n.dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(10,1,'test/data/file400.dat',5,1569566935,1569148356,1569148356,1000,1000,33024,0,1024);
INSERT INTO entries VALUES(11,1,'test/data/extended_attribute.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(12,1,'test/data/immutable.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,18);
INSERT INTO entries VALUES(13,1,'test/data/readonly.dat',5,1569566935,1569148356,1569148356,1000,1000,33056,0,12);
INSERT INTO entries VALUES(14,1,'test/data/file640.dat',5,1569566935,1569148356,1569148356,1000,1000,33184,0,1024);
INSERT INTO entries VALUES(15,1,'test/data/random128.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,128);
INSERT INTO entries VALUES(16,1,'test/data/zero128.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,128);
INSERT INTO entries VALUES(17,1,'test/data/hardlink_extended_attribute.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(18,1,'test/data/hardlinkdata_extended_attribute.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(19,1,'test/data/append-only.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,17);
INSERT INTO entries VALUES(20,1,'test/data/file644.dat',5,1569566935,1569148356,1569148356,1000,1000,33188,0,1024);
INSERT INTO entries VALUES(21,1,'test/data/name''.dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(22,1,'test/data/name".dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(23,1,'test/data/name\.dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(24,1,'test/data/link.dat',8,1569656784,1569148356,1569148356,1000,1000,41471,0,0);
INSERT INTO entries VALUES(25,1,'test/data/sub_dir_extended_attribute',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(26,1,'test/data/delta1',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(27,1,'test/data/delta2',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(28,1,'test/data/readonly512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33056,0,524288);
INSERT INTO entries VALUES(29,1,'test/data/sub_dir',7,1569566935,1569148356,1569148356,1000,1000,16877,0,0);
INSERT INTO entries VALUES(30,1,'test/data/random512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(31,1,'test/data/zero1024.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(32,1,'test/data/smallfile.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,128);
INSERT INTO entries VALUES(33,1,'test/data/random1024.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(34,1,'test/data/name%d%f%s%p.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,12);
INSERT INTO entries VALUES(35,1,'test/data/linkdata.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(36,1,'test/data/hardlink2.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(37,1,'test/data/hardlinkdata.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(38,1,'test/data/hardlink1.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(39,1,'test/data/zero512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(40,1,'test/data/sub_dir/test.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,12);
INSERT INTO entries VALUES(41,1,'test/data/delta2/test.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(42,1,'test/data/zero-random512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(43,1,'test/data/delta1/test.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(44,2,'test/data',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(45,2,'test/data/hardlink_extended_attribute.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(46,2,'test/data/hardlinkdata_extended_attribute.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(47,2,'test/data/extended_attribute.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(48,2,'test/data/immutable.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,18);
INSERT INTO entries VALUES(49,2,'test/data/file664.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(50,2,'test/data/fifo',10,1569148357,1569148357,1569148357,1000,1000,4532,0,0);
INSERT INTO entries VALUES(51,2,'test/data/readonly.dat',5,1569566935,1569148356,1569148356,1000,1000,33056,0,12);
INSERT INTO entries VALUES(52,2,'test/data/file400.dat',5,1569566935,1569148356,1569148356,1000,1000,33024,0,1024);
INSERT INTO entries VALUES(53,2,'test/data/file666.dat',5,1569566935,1569148356,1569148356,1000,1000,33206,0,1024);
INSERT INTO entries VALUES(54,2,'test/data/circular_link.dat.marker',5,1569653032,1569148356,1569148356,1000,1000,33204,0,0);
INSERT INTO entries VALUES(55,2,'test/data/link_not_existing_file.dat',8,1569656784,1569148356,1569148356,1000,1000,41471,0,0);
INSERT INTO entries VALUES(56,2,'test/data/circular_link.dat',8,1569656784,1569148356,1569148356,1000,1000,41471,0,0);
INSERT INTO entries VALUES(57,2,'test/data/zero.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,0);
INSERT INTO entries VALUES(58,2,'test/data/name".dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(59,2,'test/data/zero128.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,128);
INSERT INTO entries VALUES(60,2,'test/data/random128.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,128);
INSERT INTO entries VALUES(61,2,'test/data/name''.dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(62,2,'test/data/random512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(63,2,'test/data/zero512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(64,2,'test/data/file640.dat',5,1569566935,1569148356,1569148356,1000,1000,33184,0,1024);
INSERT INTO entries VALUES(65,2,'test/data/file644.dat',5,1569566935,1569148356,1569148356,1000,1000,33188,0,1024);
INSERT INTO entries VALUES(66,2,'test/data/zero1024.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(67,2,'test/data/link.dat',8,1569656784,1569148356,1569148356,1000,1000,41471,0,0);
INSERT INTO entries VALUES(68,2,'test/data/random1024.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,1024);
INSERT INTO entries VALUES(69,2,'test/data/append-only.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,17);
INSERT INTO entries VALUES(70,2,'test/data/name%d%f%s%p.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,12);
INSERT INTO entries VALUES(71,2,'test/data/readonly512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33056,0,524288);
INSERT INTO entries VALUES(72,2,'test/data/sub_dir_extended_attribute',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(73,2,'test/data/delta1',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(74,2,'test/data/delta2',7,1569566935,1569148357,1569148357,1000,1000,16877,0,0);
INSERT INTO entries VALUES(75,2,'test/data/sub_dir',7,1569566935,1569148356,1569148356,1000,1000,16877,0,0);
INSERT INTO entries VALUES(76,2,'test/data/hardlink2.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(77,2,'test/data/hardlinkdata.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(78,2,'test/data/hardlink1.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(79,2,'test/data/delta1/test.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(80,2,'test/data/smallfile.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,128);
INSERT INTO entries VALUES(81,2,'test/data/name\n.dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(82,2,'test/data/sub_dir/test.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,12);
INSERT INTO entries VALUES(83,2,'test/data/delta2/test.dat',5,1569566935,1569148357,1569148357,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(84,2,'test/data/linkdata.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
INSERT INTO entries VALUES(85,2,'test/data/name\.dat',5,1569653032,1569588848,1569588848,1000,1000,33204,0,12);
INSERT INTO entries VALUES(86,2,'test/data/zero-random512k.dat',5,1569566935,1569148356,1569148356,1000,1000,33204,0,524288);
CREATE TABLE entriesNewest(  id              INTEGER PRIMARY KEY,  entryId         INTEGER REFERENCES entries(id) ON DELETE CASCADE,    storageId       INTEGER DEFAULT 0,         name            TEXT NOT NULL,             type            INTEGER DEFAULT 0,         timeLastChanged INTEGER DEFAULT 0,         userId          INTEGER DEFAULT 0,         groupId         INTEGER DEFAULT 0,         permission      INTEGER DEFAULT 0,         offset          INTEGER DEFAULT 0,         size            INTEGER DEFAULT 0,         CONSTRAINT newest UNIQUE (name,offset,size));
INSERT INTO entriesNewest VALUES(1,1,1,'test/data',7,1569148357,1000,1000,16877,0,0);
INSERT INTO entriesNewest VALUES(2,2,1,'test/data/fifo',10,1569148357,1000,1000,4532,0,0);
INSERT INTO entriesNewest VALUES(3,3,1,'test/data/file664.dat',5,1569148356,1000,1000,33204,0,1024);
INSERT INTO entriesNewest VALUES(4,4,1,'test/data/file666.dat',5,1569148356,1000,1000,33206,0,1024);
INSERT INTO entriesNewest VALUES(5,5,1,'test/data/circular_link.dat.marker',5,1569148356,1000,1000,33204,0,0);
INSERT INTO entriesNewest VALUES(6,6,1,'test/data/link_not_existing_file.dat',8,1569148356,1000,1000,41471,0,0);
INSERT INTO entriesNewest VALUES(7,7,1,'test/data/circular_link.dat',8,1569148356,1000,1000,41471,0,0);
INSERT INTO entriesNewest VALUES(8,8,1,'test/data/zero.dat',5,1569148356,1000,1000,33204,0,0);
INSERT INTO entriesNewest VALUES(9,9,1,'test/data/name\n.dat',5,1569588848,1000,1000,33204,0,12);
INSERT INTO entriesNewest VALUES(10,10,1,'test/data/file400.dat',5,1569148356,1000,1000,33024,0,1024);
INSERT INTO entriesNewest VALUES(11,11,1,'test/data/extended_attribute.dat',5,1569148357,1000,1000,33204,0,1024);
INSERT INTO entriesNewest VALUES(12,12,1,'test/data/immutable.dat',5,1569148357,1000,1000,33204,0,18);
INSERT INTO entriesNewest VALUES(13,13,1,'test/data/readonly.dat',5,1569148356,1000,1000,33056,0,12);
INSERT INTO entriesNewest VALUES(14,14,1,'test/data/file640.dat',5,1569148356,1000,1000,33184,0,1024);
INSERT INTO entriesNewest VALUES(15,15,1,'test/data/random128.dat',5,1569148356,1000,1000,33204,0,128);
INSERT INTO entriesNewest VALUES(16,16,1,'test/data/zero128.dat',5,1569148356,1000,1000,33204,0,128);
INSERT INTO entriesNewest VALUES(17,17,1,'test/data/hardlink_extended_attribute.dat',5,1569148357,1000,1000,33204,0,1024);
INSERT INTO entriesNewest VALUES(18,18,1,'test/data/hardlinkdata_extended_attribute.dat',5,1569148357,1000,1000,33204,0,1024);
INSERT INTO entriesNewest VALUES(19,19,1,'test/data/append-only.dat',5,1569148357,1000,1000,33204,0,17);
INSERT INTO entriesNewest VALUES(20,20,1,'test/data/file644.dat',5,1569148356,1000,1000,33188,0,1024);
INSERT INTO entriesNewest VALUES(21,21,1,'test/data/name''.dat',5,1569588848,1000,1000,33204,0,12);
INSERT INTO entriesNewest VALUES(22,22,1,'test/data/name".dat',5,1569588848,1000,1000,33204,0,12);
INSERT INTO entriesNewest VALUES(23,23,1,'test/data/name\.dat',5,1569588848,1000,1000,33204,0,12);
INSERT INTO entriesNewest VALUES(24,24,1,'test/data/link.dat',8,1569148356,1000,1000,41471,0,0);
INSERT INTO entriesNewest VALUES(25,25,1,'test/data/sub_dir_extended_attribute',7,1569148357,1000,1000,16877,0,0);
INSERT INTO entriesNewest VALUES(26,26,1,'test/data/delta1',7,1569148357,1000,1000,16877,0,0);
INSERT INTO entriesNewest VALUES(27,27,1,'test/data/delta2',7,1569148357,1000,1000,16877,0,0);
INSERT INTO entriesNewest VALUES(28,28,1,'test/data/readonly512k.dat',5,1569148356,1000,1000,33056,0,524288);
INSERT INTO entriesNewest VALUES(29,29,1,'test/data/sub_dir',7,1569148356,1000,1000,16877,0,0);
INSERT INTO entriesNewest VALUES(30,30,1,'test/data/random512k.dat',5,1569148356,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(31,31,1,'test/data/zero1024.dat',5,1569148356,1000,1000,33204,0,1024);
INSERT INTO entriesNewest VALUES(32,32,1,'test/data/smallfile.dat',5,1569148356,1000,1000,33204,0,128);
INSERT INTO entriesNewest VALUES(33,33,1,'test/data/random1024.dat',5,1569148356,1000,1000,33204,0,1024);
INSERT INTO entriesNewest VALUES(34,34,1,'test/data/name%d%f%s%p.dat',5,1569148357,1000,1000,33204,0,12);
INSERT INTO entriesNewest VALUES(35,35,1,'test/data/linkdata.dat',5,1569148356,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(36,36,1,'test/data/hardlink2.dat',5,1569148356,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(37,37,1,'test/data/hardlinkdata.dat',5,1569148356,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(38,38,1,'test/data/hardlink1.dat',5,1569148356,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(39,39,1,'test/data/zero512k.dat',5,1569148356,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(40,40,1,'test/data/sub_dir/test.dat',5,1569148356,1000,1000,33204,0,12);
INSERT INTO entriesNewest VALUES(41,41,1,'test/data/delta2/test.dat',5,1569148357,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(42,42,1,'test/data/zero-random512k.dat',5,1569148356,1000,1000,33204,0,524288);
INSERT INTO entriesNewest VALUES(43,43,1,'test/data/delta1/test.dat',5,1569148357,1000,1000,33204,0,524288);
INSERT INTO sqlite_master(type,name,tbl_name,rootpage,sql)VALUES('table','FTS_entries','FTS_entries',0,'CREATE VIRTUAL TABLE FTS_entries USING FTS4(  entryId,  name,  tokenize=unicode61)');
CREATE TABLE IF NOT EXISTS 'FTS_entries_content'(docid INTEGER PRIMARY KEY, 'c0entryId', 'c1name');
INSERT INTO FTS_entries_content VALUES(1,1,'test/data');
INSERT INTO FTS_entries_content VALUES(2,2,'test/data/fifo');
INSERT INTO FTS_entries_content VALUES(3,3,'test/data/file664.dat');
INSERT INTO FTS_entries_content VALUES(4,4,'test/data/file666.dat');
INSERT INTO FTS_entries_content VALUES(5,5,'test/data/circular_link.dat.marker');
INSERT INTO FTS_entries_content VALUES(6,6,'test/data/link_not_existing_file.dat');
INSERT INTO FTS_entries_content VALUES(7,7,'test/data/circular_link.dat');
INSERT INTO FTS_entries_content VALUES(8,8,'test/data/zero.dat');
INSERT INTO FTS_entries_content VALUES(9,9,'test/data/name\n.dat');
INSERT INTO FTS_entries_content VALUES(10,10,'test/data/file400.dat');
INSERT INTO FTS_entries_content VALUES(11,11,'test/data/extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(12,12,'test/data/immutable.dat');
INSERT INTO FTS_entries_content VALUES(13,13,'test/data/readonly.dat');
INSERT INTO FTS_entries_content VALUES(14,14,'test/data/file640.dat');
INSERT INTO FTS_entries_content VALUES(15,15,'test/data/random128.dat');
INSERT INTO FTS_entries_content VALUES(16,16,'test/data/zero128.dat');
INSERT INTO FTS_entries_content VALUES(17,17,'test/data/hardlink_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(18,18,'test/data/hardlinkdata_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(19,19,'test/data/append-only.dat');
INSERT INTO FTS_entries_content VALUES(20,20,'test/data/file644.dat');
INSERT INTO FTS_entries_content VALUES(21,21,'test/data/name''.dat');
INSERT INTO FTS_entries_content VALUES(22,22,'test/data/name".dat');
INSERT INTO FTS_entries_content VALUES(23,23,'test/data/name\.dat');
INSERT INTO FTS_entries_content VALUES(24,24,'test/data/link.dat');
INSERT INTO FTS_entries_content VALUES(25,25,'test/data/sub_dir_extended_attribute');
INSERT INTO FTS_entries_content VALUES(26,26,'test/data/delta1');
INSERT INTO FTS_entries_content VALUES(27,27,'test/data/delta2');
INSERT INTO FTS_entries_content VALUES(28,28,'test/data/readonly512k.dat');
INSERT INTO FTS_entries_content VALUES(29,29,'test/data/sub_dir');
INSERT INTO FTS_entries_content VALUES(30,30,'test/data/random512k.dat');
INSERT INTO FTS_entries_content VALUES(31,31,'test/data/zero1024.dat');
INSERT INTO FTS_entries_content VALUES(32,32,'test/data/smallfile.dat');
INSERT INTO FTS_entries_content VALUES(33,33,'test/data/random1024.dat');
INSERT INTO FTS_entries_content VALUES(34,34,'test/data/name%d%f%s%p.dat');
INSERT INTO FTS_entries_content VALUES(35,35,'test/data/linkdata.dat');
INSERT INTO FTS_entries_content VALUES(36,36,'test/data/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(37,37,'test/data/hardlinkdata.dat');
INSERT INTO FTS_entries_content VALUES(38,38,'test/data/hardlink1.dat');
INSERT INTO FTS_entries_content VALUES(39,39,'test/data/zero512k.dat');
INSERT INTO FTS_entries_content VALUES(40,40,'test/data/sub_dir/test.dat');
INSERT INTO FTS_entries_content VALUES(41,41,'test/data/delta2/test.dat');
INSERT INTO FTS_entries_content VALUES(42,42,'test/data/zero-random512k.dat');
INSERT INTO FTS_entries_content VALUES(43,43,'test/data/delta1/test.dat');
INSERT INTO FTS_entries_content VALUES(44,44,'test/data');
INSERT INTO FTS_entries_content VALUES(45,45,'test/data/hardlink_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(46,46,'test/data/hardlinkdata_extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(47,47,'test/data/extended_attribute.dat');
INSERT INTO FTS_entries_content VALUES(48,48,'test/data/immutable.dat');
INSERT INTO FTS_entries_content VALUES(49,49,'test/data/file664.dat');
INSERT INTO FTS_entries_content VALUES(50,50,'test/data/fifo');
INSERT INTO FTS_entries_content VALUES(51,51,'test/data/readonly.dat');
INSERT INTO FTS_entries_content VALUES(52,52,'test/data/file400.dat');
INSERT INTO FTS_entries_content VALUES(53,53,'test/data/file666.dat');
INSERT INTO FTS_entries_content VALUES(54,54,'test/data/circular_link.dat.marker');
INSERT INTO FTS_entries_content VALUES(55,55,'test/data/link_not_existing_file.dat');
INSERT INTO FTS_entries_content VALUES(56,56,'test/data/circular_link.dat');
INSERT INTO FTS_entries_content VALUES(57,57,'test/data/zero.dat');
INSERT INTO FTS_entries_content VALUES(58,58,'test/data/name".dat');
INSERT INTO FTS_entries_content VALUES(59,59,'test/data/zero128.dat');
INSERT INTO FTS_entries_content VALUES(60,60,'test/data/random128.dat');
INSERT INTO FTS_entries_content VALUES(61,61,'test/data/name''.dat');
INSERT INTO FTS_entries_content VALUES(62,62,'test/data/random512k.dat');
INSERT INTO FTS_entries_content VALUES(63,63,'test/data/zero512k.dat');
INSERT INTO FTS_entries_content VALUES(64,64,'test/data/file640.dat');
INSERT INTO FTS_entries_content VALUES(65,65,'test/data/file644.dat');
INSERT INTO FTS_entries_content VALUES(66,66,'test/data/zero1024.dat');
INSERT INTO FTS_entries_content VALUES(67,67,'test/data/link.dat');
INSERT INTO FTS_entries_content VALUES(68,68,'test/data/random1024.dat');
INSERT INTO FTS_entries_content VALUES(69,69,'test/data/append-only.dat');
INSERT INTO FTS_entries_content VALUES(70,70,'test/data/name%d%f%s%p.dat');
INSERT INTO FTS_entries_content VALUES(71,71,'test/data/readonly512k.dat');
INSERT INTO FTS_entries_content VALUES(72,72,'test/data/sub_dir_extended_attribute');
INSERT INTO FTS_entries_content VALUES(73,73,'test/data/delta1');
INSERT INTO FTS_entries_content VALUES(74,74,'test/data/delta2');
INSERT INTO FTS_entries_content VALUES(75,75,'test/data/sub_dir');
INSERT INTO FTS_entries_content VALUES(76,76,'test/data/hardlink2.dat');
INSERT INTO FTS_entries_content VALUES(77,77,'test/data/hardlinkdata.dat');
INSERT INTO FTS_entries_content VALUES(78,78,'test/data/hardlink1.dat');
INSERT INTO FTS_entries_content VALUES(79,79,'test/data/delta1/test.dat');
INSERT INTO FTS_entries_content VALUES(80,80,'test/data/smallfile.dat');
INSERT INTO FTS_entries_content VALUES(81,81,'test/data/name\n.dat');
INSERT INTO FTS_entries_content VALUES(82,82,'test/data/sub_dir/test.dat');
INSERT INTO FTS_entries_content VALUES(83,83,'test/data/delta2/test.dat');
INSERT INTO FTS_entries_content VALUES(84,84,'test/data/linkdata.dat');
INSERT INTO FTS_entries_content VALUES(85,85,'test/data/name\.dat');
INSERT INTO FTS_entries_content VALUES(86,86,'test/data/zero-random512k.dat');
CREATE TABLE IF NOT EXISTS 'FTS_entries_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'FTS_entries_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
INSERT INTO FTS_entries_segdir VALUES(1,0,0,0,'0 628',X'00013103010200010130030a0200010131030b0200010132030c0200010133030d0200010134030e0200010135030f02000101360310020000013203020200000133030302000001340304020000013503050200000136030602000001370307020000013803080200000139030902000009617474726962757465050b01010500000863697263756c61720a050101040002010104000003646174460301010500010101050001010106000101010800010101060001010105000101010600010101050001010106000101010500010101050001010105000101010500010101050003016150010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030000086578697374696e67050601010600020674656e646564050b0101040000046669666f05020101040002026c650506010107000403343030050a010104000403363430050e01010400050236340503010104000601360504010104000009696d6d757461626c65050c0101040000046c696e6b0f05010105000101010400010101050000066d61726b657205050101070000016e0509010105000103616d6505090101040001026f74050601010500000972616e646f6d313238050f0101040001076561646f6e6c79050d0101040000047465737450010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020000047a65726f0508010104000403313238051001010400');
INSERT INTO FTS_entries_segdir VALUES(1,1,0,0,'0 629',X'0002313703110200010138031202000101390313020000023230031402000101310315020001013203160200010133031702000101340318020001013503190200010136031a0200010137031b0200010138031c0200010139031d020000023330031e0200010131031f0200010132032002000006617070656e64051301010400010874747269627574650f11010106000101010600070101070000036461743c1101010700010101070001010106000101010500010101050001010105000101010500010101050004010105000201010500010101050001010105000301615011010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000105656c746131051a01010400050132051b01010400010269720a190101050004010105000008657874656e6465640f110101050001010105000701010600000766696c653634340514010104000008686172646c696e6b05110101040008046461746105120101040000046c696e6b05180101040000046e616d650f15010104000101010400010101040000046f6e6c79051301010500000a72616e646f6d3531326b051e01010400010b6561646f6e6c793531326b051c010104000009736d616c6c66696c65052001010400010275620a1901010400040101040000047465737450110101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020000087a65726f31303234051f01010400');
INSERT INTO FTS_entries_segdir VALUES(1,2,0,0,'0 649',X'0002333303210200010134032202000101350323020001013603240200010137032502000101380326020001013903270200000234300328020001013103290200010132032a0200010133032b0200010134032c0200010135032d0200010136032e0200010137032f02000101380330020000096174747269627574650f2d0101060001010106000101010500000164052201010500010261744b2101010500010101090001010105000101010500010101050001010105000101010500010101070001010106000101010600010101060002010107000101010700010101060001010105000301615021010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000105656c746131052b01010400050132052901010400010269720528010105000008657874656e6465640f2d01010500010101050001010104000001660522010106000008686172646c696e6b052d010104000801310526010104000801320524010104000804646174610a250101040009010104000009696d6d757461626c6505300101040000086c696e6b6461746105230101040000046e616d65052201010400000170052201010800000a72616e646f6d3130323405210101040006043531326b052a010105000001730522010107000102756205280101040000047465737453210101020001010102000101010200010101020001010102000101010200010101020001010102060001010102050001010102000101010205000101010200010101020001010102000101010200010101020000047a65726f052a0101040004043531326b052701010400');
INSERT INTO FTS_entries_segdir VALUES(1,3,0,0,'0 609',X'0002343903310200000235300332020001013103330200010132033402000101330335020001013403360200010135033702000101360338020001013703390200010138033a0200010139033b020000023630033c0200010131033d0200010132033e0200010133033f020001013403400200000863697263756c61720a3601010400020101040000036461744b31010105000201010500010101050001010105000101010600010101080001010106000101010500010101050001010105000101010500010101050001010105000101010500010101050003016150310101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030000086578697374696e6705370101060000046669666f05320101040002026c65053701010700040334303005340101040004033634300540010104000502363405310101040006013605350101040000046c696e6b0f36010105000101010400010101050000066d61726b657205360101070000046e616d650a3a01010400030101040001026f74053701010500000972616e646f6d313238053c0101040006043531326b053e0101040001076561646f6e6c7905330101040000047465737450310101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020000047a65726f0539010104000403313238053b0101040004043531326b053f01010400');
INSERT INTO FTS_entries_segdir VALUES(1,4,0,0,'0 648',X'0002363503410200010136034202000101370343020001013803440200010139034502000002373003460200010131034702000101320348020001013303490200010134034a0200010135034b0200010136034c0200010137034d0200010138034e0200010139034f020000023830035002000006617070656e6405450101040001087474726962757465054801010700000164054601010500010261743c4101010500010101050001010105000101010500010101060001010109000101010500050101050001010105000101010500010101060001010105000301615041010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000101010300010101030001010103000105656c7461310a49010104000601010400050132054a01010400010269720a480101050003010105000008657874656e6465640548010106000001660546010106000106696c653634340541010104000009686172646c696e6b31054e01010400080132054c01010400080464617461054d0101040000046c696e6b05430101040000046e616d6505460101040000046f6e6c79054501010500000170054601010800000a72616e646f6d31303234054401010400010b6561646f6e6c793531326b05470101040000017305460101070001086d616c6c66696c65055001010400010275620a480101040003010104000004746573745141010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020001010102000101010200010101020500010101020000087a65726f31303234054201010400');
INSERT INTO FTS_entries_segdir VALUES(0,0,0,0,'0 60',X'0002383103510200000364617405510101060003016105510101030000016e0551010105000103616d65055101010400000474657374055101010200');
INSERT INTO FTS_entries_segdir VALUES(0,1,0,0,'0 62',X'0002383203520200000364617405520101070003016105520101030001026972055201010500000373756205520101040000047465737406520101020600');
INSERT INTO FTS_entries_segdir VALUES(0,2,0,0,'0 54',X'000238330353020000036461740553010106000301610553010103000105656c74613205530101040000047465737406530101020500');
INSERT INTO FTS_entries_segdir VALUES(0,3,0,0,'0 56',X'0002383403540200000364617405540101050003016105540101030000086c696e6b64617461055401010400000474657374055401010200');
INSERT INTO FTS_entries_segdir VALUES(0,4,0,0,'0 52',X'0002383503550200000364617405550101050003016105550101030000046e616d65055501010400000474657374055501010200');
INSERT INTO FTS_entries_segdir VALUES(0,5,0,0,'0 70',X'00023836035602000003646174055601010600030161055601010300000a72616e646f6d3531326b05560101050000047465737405560101020000047a65726f055601010400');
CREATE TABLE IF NOT EXISTS 'FTS_entries_docsize'(docid INTEGER PRIMARY KEY, size BLOB);
INSERT INTO FTS_entries_docsize VALUES(1,X'0102');
INSERT INTO FTS_entries_docsize VALUES(2,X'0103');
INSERT INTO FTS_entries_docsize VALUES(3,X'0104');
INSERT INTO FTS_entries_docsize VALUES(4,X'0104');
INSERT INTO FTS_entries_docsize VALUES(5,X'0106');
INSERT INTO FTS_entries_docsize VALUES(6,X'0107');
INSERT INTO FTS_entries_docsize VALUES(7,X'0105');
INSERT INTO FTS_entries_docsize VALUES(8,X'0104');
INSERT INTO FTS_entries_docsize VALUES(9,X'0105');
INSERT INTO FTS_entries_docsize VALUES(10,X'0104');
INSERT INTO FTS_entries_docsize VALUES(11,X'0105');
INSERT INTO FTS_entries_docsize VALUES(12,X'0104');
INSERT INTO FTS_entries_docsize VALUES(13,X'0104');
INSERT INTO FTS_entries_docsize VALUES(14,X'0104');
INSERT INTO FTS_entries_docsize VALUES(15,X'0104');
INSERT INTO FTS_entries_docsize VALUES(16,X'0104');
INSERT INTO FTS_entries_docsize VALUES(17,X'0106');
INSERT INTO FTS_entries_docsize VALUES(18,X'0106');
INSERT INTO FTS_entries_docsize VALUES(19,X'0105');
INSERT INTO FTS_entries_docsize VALUES(20,X'0104');
INSERT INTO FTS_entries_docsize VALUES(21,X'0104');
INSERT INTO FTS_entries_docsize VALUES(22,X'0104');
INSERT INTO FTS_entries_docsize VALUES(23,X'0104');
INSERT INTO FTS_entries_docsize VALUES(24,X'0104');
INSERT INTO FTS_entries_docsize VALUES(25,X'0106');
INSERT INTO FTS_entries_docsize VALUES(26,X'0103');
INSERT INTO FTS_entries_docsize VALUES(27,X'0103');
INSERT INTO FTS_entries_docsize VALUES(28,X'0104');
INSERT INTO FTS_entries_docsize VALUES(29,X'0104');
INSERT INTO FTS_entries_docsize VALUES(30,X'0104');
INSERT INTO FTS_entries_docsize VALUES(31,X'0104');
INSERT INTO FTS_entries_docsize VALUES(32,X'0104');
INSERT INTO FTS_entries_docsize VALUES(33,X'0104');
INSERT INTO FTS_entries_docsize VALUES(34,X'0108');
INSERT INTO FTS_entries_docsize VALUES(35,X'0104');
INSERT INTO FTS_entries_docsize VALUES(36,X'0104');
INSERT INTO FTS_entries_docsize VALUES(37,X'0104');
INSERT INTO FTS_entries_docsize VALUES(38,X'0104');
INSERT INTO FTS_entries_docsize VALUES(39,X'0104');
INSERT INTO FTS_entries_docsize VALUES(40,X'0106');
INSERT INTO FTS_entries_docsize VALUES(41,X'0105');
INSERT INTO FTS_entries_docsize VALUES(42,X'0105');
INSERT INTO FTS_entries_docsize VALUES(43,X'0105');
INSERT INTO FTS_entries_docsize VALUES(44,X'0102');
INSERT INTO FTS_entries_docsize VALUES(45,X'0106');
INSERT INTO FTS_entries_docsize VALUES(46,X'0106');
INSERT INTO FTS_entries_docsize VALUES(47,X'0105');
INSERT INTO FTS_entries_docsize VALUES(48,X'0104');
INSERT INTO FTS_entries_docsize VALUES(49,X'0104');
INSERT INTO FTS_entries_docsize VALUES(50,X'0103');
INSERT INTO FTS_entries_docsize VALUES(51,X'0104');
INSERT INTO FTS_entries_docsize VALUES(52,X'0104');
INSERT INTO FTS_entries_docsize VALUES(53,X'0104');
INSERT INTO FTS_entries_docsize VALUES(54,X'0106');
INSERT INTO FTS_entries_docsize VALUES(55,X'0107');
INSERT INTO FTS_entries_docsize VALUES(56,X'0105');
INSERT INTO FTS_entries_docsize VALUES(57,X'0104');
INSERT INTO FTS_entries_docsize VALUES(58,X'0104');
INSERT INTO FTS_entries_docsize VALUES(59,X'0104');
INSERT INTO FTS_entries_docsize VALUES(60,X'0104');
INSERT INTO FTS_entries_docsize VALUES(61,X'0104');
INSERT INTO FTS_entries_docsize VALUES(62,X'0104');
INSERT INTO FTS_entries_docsize VALUES(63,X'0104');
INSERT INTO FTS_entries_docsize VALUES(64,X'0104');
INSERT INTO FTS_entries_docsize VALUES(65,X'0104');
INSERT INTO FTS_entries_docsize VALUES(66,X'0104');
INSERT INTO FTS_entries_docsize VALUES(67,X'0104');
INSERT INTO FTS_entries_docsize VALUES(68,X'0104');
INSERT INTO FTS_entries_docsize VALUES(69,X'0105');
INSERT INTO FTS_entries_docsize VALUES(70,X'0108');
INSERT INTO FTS_entries_docsize VALUES(71,X'0104');
INSERT INTO FTS_entries_docsize VALUES(72,X'0106');
INSERT INTO FTS_entries_docsize VALUES(73,X'0103');
INSERT INTO FTS_entries_docsize VALUES(74,X'0103');
INSERT INTO FTS_entries_docsize VALUES(75,X'0104');
INSERT INTO FTS_entries_docsize VALUES(76,X'0104');
INSERT INTO FTS_entries_docsize VALUES(77,X'0104');
INSERT INTO FTS_entries_docsize VALUES(78,X'0104');
INSERT INTO FTS_entries_docsize VALUES(79,X'0105');
INSERT INTO FTS_entries_docsize VALUES(80,X'0104');
INSERT INTO FTS_entries_docsize VALUES(81,X'0105');
INSERT INTO FTS_entries_docsize VALUES(82,X'0106');
INSERT INTO FTS_entries_docsize VALUES(83,X'0105');
INSERT INTO FTS_entries_docsize VALUES(84,X'0104');
INSERT INTO FTS_entries_docsize VALUES(85,X'0104');
INSERT INTO FTS_entries_docsize VALUES(86,X'0105');
CREATE TABLE IF NOT EXISTS 'FTS_entries_stat'(id INTEGER PRIMARY KEY, value BLOB);
INSERT INTO FTS_entries_stat VALUES(0,X'5656fe029d11');
CREATE TABLE skippedEntries(  id              INTEGER PRIMARY KEY,  storageId       INTEGER NOT NULL REFERENCES storage(id),  name            TEXT NOT NULL,  type            INTEGER);
CREATE TABLE fileEntries(  id              INTEGER PRIMARY KEY,  storageId       INTEGER NOT NULL REFERENCES storage(id) ON DELETE CASCADE,    entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,  size            INTEGER,  fragmentOffset  INTEGER,  fragmentSize    INTEGER);
INSERT INTO fileEntries VALUES(1,1,3,1024,0,1024);
INSERT INTO fileEntries VALUES(2,1,4,1024,0,1024);
INSERT INTO fileEntries VALUES(3,1,5,0,0,0);
INSERT INTO fileEntries VALUES(4,1,8,0,0,0);
INSERT INTO fileEntries VALUES(5,1,9,12,0,12);
INSERT INTO fileEntries VALUES(6,1,10,1024,0,1024);
INSERT INTO fileEntries VALUES(7,1,11,1024,0,1024);
INSERT INTO fileEntries VALUES(8,1,12,18,0,18);
INSERT INTO fileEntries VALUES(9,1,13,12,0,12);
INSERT INTO fileEntries VALUES(10,1,14,1024,0,1024);
INSERT INTO fileEntries VALUES(11,1,15,128,0,128);
INSERT INTO fileEntries VALUES(12,1,16,128,0,128);
INSERT INTO fileEntries VALUES(13,1,17,1024,0,1024);
INSERT INTO fileEntries VALUES(14,1,18,1024,0,1024);
INSERT INTO fileEntries VALUES(15,1,19,17,0,17);
INSERT INTO fileEntries VALUES(16,1,20,1024,0,1024);
INSERT INTO fileEntries VALUES(17,1,21,12,0,12);
INSERT INTO fileEntries VALUES(18,1,22,12,0,12);
INSERT INTO fileEntries VALUES(19,1,23,12,0,12);
INSERT INTO fileEntries VALUES(20,1,28,524288,0,524288);
INSERT INTO fileEntries VALUES(21,1,30,524288,0,524288);
INSERT INTO fileEntries VALUES(22,1,31,1024,0,1024);
INSERT INTO fileEntries VALUES(23,1,32,128,0,128);
INSERT INTO fileEntries VALUES(24,1,33,1024,0,1024);
INSERT INTO fileEntries VALUES(25,1,34,12,0,12);
INSERT INTO fileEntries VALUES(26,1,35,524288,0,524288);
INSERT INTO fileEntries VALUES(27,1,36,524288,0,524288);
INSERT INTO fileEntries VALUES(28,1,37,524288,0,524288);
INSERT INTO fileEntries VALUES(29,1,38,524288,0,524288);
INSERT INTO fileEntries VALUES(30,1,39,524288,0,524288);
INSERT INTO fileEntries VALUES(31,1,40,12,0,12);
INSERT INTO fileEntries VALUES(32,1,41,524288,0,524288);
INSERT INTO fileEntries VALUES(33,1,42,524288,0,524288);
INSERT INTO fileEntries VALUES(34,1,43,524288,0,524288);
INSERT INTO fileEntries VALUES(35,2,45,1024,0,1024);
INSERT INTO fileEntries VALUES(36,2,46,1024,0,1024);
INSERT INTO fileEntries VALUES(37,2,47,1024,0,1024);
INSERT INTO fileEntries VALUES(38,2,48,18,0,18);
INSERT INTO fileEntries VALUES(39,2,49,1024,0,1024);
INSERT INTO fileEntries VALUES(40,2,51,12,0,12);
INSERT INTO fileEntries VALUES(41,2,52,1024,0,1024);
INSERT INTO fileEntries VALUES(42,2,53,1024,0,1024);
INSERT INTO fileEntries VALUES(43,2,54,0,0,0);
INSERT INTO fileEntries VALUES(44,2,57,0,0,0);
INSERT INTO fileEntries VALUES(45,2,58,12,0,12);
INSERT INTO fileEntries VALUES(46,2,59,128,0,128);
INSERT INTO fileEntries VALUES(47,2,60,128,0,128);
INSERT INTO fileEntries VALUES(48,2,61,12,0,12);
INSERT INTO fileEntries VALUES(49,2,62,524288,0,524288);
INSERT INTO fileEntries VALUES(50,2,63,524288,0,524288);
INSERT INTO fileEntries VALUES(51,2,64,1024,0,1024);
INSERT INTO fileEntries VALUES(52,2,65,1024,0,1024);
INSERT INTO fileEntries VALUES(53,2,66,1024,0,1024);
INSERT INTO fileEntries VALUES(54,2,68,1024,0,1024);
INSERT INTO fileEntries VALUES(55,2,69,17,0,17);
INSERT INTO fileEntries VALUES(56,2,70,12,0,12);
INSERT INTO fileEntries VALUES(57,2,71,524288,0,524288);
INSERT INTO fileEntries VALUES(58,2,76,524288,0,524288);
INSERT INTO fileEntries VALUES(59,2,77,524288,0,524288);
INSERT INTO fileEntries VALUES(60,2,78,524288,0,524288);
INSERT INTO fileEntries VALUES(61,2,79,524288,0,524288);
INSERT INTO fileEntries VALUES(62,2,80,128,0,128);
INSERT INTO fileEntries VALUES(63,2,81,12,0,12);
INSERT INTO fileEntries VALUES(64,2,82,12,0,12);
INSERT INTO fileEntries VALUES(65,2,83,524288,0,524288);
INSERT INTO fileEntries VALUES(66,2,84,524288,0,524288);
INSERT INTO fileEntries VALUES(67,2,85,12,0,12);
INSERT INTO fileEntries VALUES(68,2,86,524288,0,524288);
CREATE TABLE imageEntries(  id              INTEGER PRIMARY KEY,  storageId       INTEGER NOT NULL REFERENCES storage(id) ON DELETE CASCADE,    entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,  size            INTEGER,  fileSystemType  INTEGER,  blockSize       INTEGER,                   blockOffset     INTEGER,                   blockCount      INTEGER                  );
INSERT INTO "imageEntries" VALUES(1,1,'/dev/loop0',0,33554432,4096,0,8192);
INSERT INTO "imageEntries" VALUES(2,2,'/dev/loop1',1,33554432,4096,0,8192);
CREATE TABLE directoryEntries(  id                    INTEGER PRIMARY KEY,  storageId             INTEGER NOT NULL REFERENCES storage(id),    entryId               INTEGER NOT NULL REFERENCES entries(id),  name                  TEXT,                                       totalEntryCount       INTEGER DEFAULT 0,    totalEntrySize        INTEGER DEFAULT 0,    totalEntryCountNewest INTEGER DEFAULT 0,    totalEntrySizeNewest  INTEGER DEFAULT 0   );
INSERT INTO directoryEntries VALUES(1,1,1,'test/data',42,5253623,42,5253623);
INSERT INTO directoryEntries VALUES(2,1,25,'test/data/sub_dir_extended_attribute',0,0,0,0);
INSERT INTO directoryEntries VALUES(3,1,26,'test/data/delta1',1,524288,1,524288);
INSERT INTO directoryEntries VALUES(4,1,27,'test/data/delta2',1,524288,1,524288);
INSERT INTO directoryEntries VALUES(5,1,29,'test/data/sub_dir',1,12,1,12);
INSERT INTO directoryEntries VALUES(6,2,44,'test/data',42,5253623,0,0);
INSERT INTO directoryEntries VALUES(7,2,72,'test/data/sub_dir_extended_attribute',0,0,0,0);
INSERT INTO directoryEntries VALUES(8,2,73,'test/data/delta1',1,524288,0,0);
INSERT INTO directoryEntries VALUES(9,2,74,'test/data/delta2',1,524288,0,0);
INSERT INTO directoryEntries VALUES(10,2,75,'test/data/sub_dir',1,12,0,0);
CREATE TABLE linkEntries(  id              INTEGER PRIMARY KEY,  storageId       INTEGER NOT NULL REFERENCES storage(id) ON DELETE CASCADE,    entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,  destinationName TEXT);
INSERT INTO linkEntries VALUES(1,1,6,'not-existing-file');
INSERT INTO linkEntries VALUES(2,1,7,'circular_link.dat');
INSERT INTO linkEntries VALUES(3,1,24,'linkdata.dat');
INSERT INTO linkEntries VALUES(4,2,55,'not-existing-file');
INSERT INTO linkEntries VALUES(5,2,56,'circular_link.dat');
INSERT INTO linkEntries VALUES(6,2,67,'linkdata.dat');
CREATE TABLE hardlinkEntries(  id              INTEGER PRIMARY KEY,  storageId       INTEGER NOT NULL REFERENCES storage(id) ON DELETE CASCADE,    entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,  size            INTEGER,  fragmentOffset  INTEGER,  fragmentSize    INTEGER);
CREATE TABLE specialEntries(  id              INTEGER PRIMARY KEY,  storageId       INTEGER NOT NULL REFERENCES storage(id) ON DELETE CASCADE,    entryId         INTEGER NOT NULL REFERENCES entries(id) ON DELETE CASCADE,  specialType     INTEGER,  major           INTEGER,  minor           INTEGER);
INSERT INTO specialEntries VALUES(1,1,2,2,0,0);
INSERT INTO specialEntries VALUES(2,2,50,2,0,0);
CREATE TABLE history(  id                INTEGER PRIMARY KEY,  jobUUID           TEXT NOT NULL,  scheduleUUID      TEXT,  hostName          TEXT,  type              INTEGER,  created           INTEGER,  errorMessage      TEXT,  duration          INTEGER,  totalEntryCount   INTEGER,  totalEntrySize    INTEGER,  skippedEntryCount INTEGER,  skippedEntrySize  INTEGER,  errorEntryCount   INTEGER,  errorEntrySize    INTEGER);
INSERT INTO history VALUES(1,'8501b352-250f-4a45-877c-569b9e322681','','tooku',2,1569656974414108,'file ''test.bar'' already exists',0,44,5253635,1,1024,1,12);
INSERT INTO history VALUES(2,'8501b352-250f-4a45-877c-569b9e322681','','tooku',2,1569656987435877,'',0,44,5253635,1,1024,1,12);
CREATE TABLE log(  text TEXT);
CREATE INDEX index0 ON uuids (jobUUID);
CREATE INDEX index1 ON entities (jobUUID,created,type);
CREATE TRIGGER trigger2 AFTER INSERT ON entities  BEGIN    INSERT OR IGNORE INTO uuids      (jobUUID) VALUES (NEW.jobUUID);  END;
CREATE INDEX index3 ON storage (entityId,name,created,state);
CREATE INDEX index4 ON storage (name,totalEntryCount,created,state);
CREATE INDEX index5 ON storage (created,name,totalEntryCount,state);
CREATE INDEX index6 ON storage (state,name,totalEntryCount,created);
CREATE TRIGGER trigger7 AFTER INSERT ON storage  BEGIN    INSERT INTO FTS_storage VALUES (NEW.id,NEW.name);  END;
CREATE TRIGGER trigger8 BEFORE DELETE ON storage  BEGIN    DELETE FROM FTS_storage WHERE storageId MATCH OLD.id;  END;
CREATE TRIGGER trigger9 AFTER UPDATE OF name ON storage  BEGIN    DELETE FROM FTS_storage WHERE storageId MATCH OLD.id;    INSERT INTO FTS_storage VALUES (NEW.id,NEW.name);  END;
CREATE INDEX index10 ON entries (storageId,type,name);
CREATE INDEX index11 ON entries (name,offset,size);
CREATE INDEX index12 ON entries (type,name);
CREATE INDEX index13 ON entriesNewest (entryId,name,offset,size,timeLastChanged);
CREATE INDEX index14 ON entriesNewest (name,offset,size,timeLastChanged);
CREATE INDEX index15 ON entriesNewest (type,name);
CREATE INDEX index16 ON entriesNewest (storageId,type);
CREATE TRIGGER trigger17 AFTER INSERT ON entries  BEGIN    INSERT INTO FTS_entries VALUES (NEW.id,NEW.name);  END;
CREATE TRIGGER trigger18 AFTER UPDATE OF storageId ON entries  BEGIN    UPDATE fileEntries      SET storageId=NEW.storageId WHERE entryId=NEW.id;    UPDATE imageEntries     SET storageId=NEW.storageId WHERE entryId=NEW.id;    UPDATE directoryEntries SET storageId=NEW.storageId WHERE entryId=NEW.id;    UPDATE linkEntries      SET storageId=NEW.storageId WHERE entryId=NEW.id;    UPDATE hardlinkEntries  SET storageId=NEW.storageId WHERE entryId=NEW.id;    UPDATE specialEntries   SET storageId=NEW.storageId WHERE entryId=NEW.id;    UPDATE entriesNewest      SET storageId=NEW.storageId      WHERE entryId=OLD.id;  END;
CREATE TRIGGER trigger19 AFTER UPDATE OF name ON entries  BEGIN    DELETE FROM FTS_entries WHERE entryId MATCH OLD.id;    INSERT INTO FTS_entries VALUES (NEW.id,NEW.name);  END;
CREATE TRIGGER trigger20 AFTER UPDATE OF offset,size ON entries  BEGIN    INSERT OR IGNORE INTO entriesNewest        (         entryId,         storageId,         type,         name,         timeLastChanged,         userId,         groupId,         permission,         offset,         size        )      VALUES        (         NEW.id,         NEW.storageId,         NEW.type,         NEW.name,         NEW.timeLastChanged,         NEW.userId,         NEW.groupId,         NEW.permission,         NEW.offset,         NEW.size        );    UPDATE entriesNewest      SET entryId        =NEW.id,          storageId      =NEW.storageId,          type           =NEW.type,          timeLastChanged=NEW.timeLastChanged,          userId         =NEW.userId,          groupId        =NEW.groupId,          permission     =NEW.permission,          offset         =NEW.offset,          size           =NEW.size      WHERE     entryId!=NEW.id            AND name=NEW.name            AND offset=NEW.offset            AND size=NEW.size            AND NEW.timeLastChanged>timeLastChanged;  END;
CREATE TRIGGER trigger21 BEFORE DELETE ON entries  BEGIN    DELETE FROM entriesNewest WHERE entryId=OLD.id;    INSERT OR IGNORE INTO entriesNewest        (entryId,storageId,name,type,size,timeLastChanged,offset,size)      SELECT id,storageId,name,type,size,MAX(timeLastChanged),offset,size        FROM entries        WHERE     id!=OLD.id              AND name=OLD.name              AND offset=OLD.offset              AND size=OLD.size;    DELETE FROM FTS_entries WHERE entryId MATCH OLD.id;  END;
CREATE INDEX index22 ON skippedEntries (storageId,type,name);
CREATE INDEX index23 ON skippedEntries (name);
CREATE INDEX index24 ON skippedEntries (type,name);
CREATE INDEX index25 ON fileEntries (storageId);
CREATE INDEX index26 ON fileEntries (entryId);
CREATE TRIGGER trigger27 AFTER INSERT ON fileEntries  BEGIN    UPDATE entries      SET offset=NEW.fragmentOffset,          size  =NEW.fragmentSize      WHERE id=NEW.entryId;  END;
CREATE INDEX index28 ON imageEntries (storageId);
CREATE INDEX index29 ON imageEntries (entryId);
CREATE TRIGGER trigger30 AFTER INSERT ON imageEntries  BEGIN    UPDATE entries      SET offset=NEW.blockSize*NEW.blockOffset,          size  =NEW.blockSize*NEW.blockCount      WHERE id=NEW.entryId;  END;
CREATE INDEX index31 ON directoryEntries (storageId,name);
CREATE INDEX index32 ON directoryEntries (entryId);
CREATE INDEX index33 ON directoryEntries (name);
CREATE TRIGGER trigger34 AFTER INSERT ON directoryEntries  BEGIN    UPDATE entries      SET offset=0,          size  =0      WHERE id=NEW.entryId;  END;
CREATE INDEX index35 ON linkEntries (storageId);
CREATE INDEX index36 ON linkEntries (entryId);
CREATE TRIGGER trigger37 AFTER INSERT ON linkEntries  BEGIN    UPDATE entries      SET offset=0,          size  =0      WHERE id=NEW.entryId;  END;
CREATE INDEX index38 ON hardlinkEntries (storageId);
CREATE INDEX index39 ON hardlinkEntries (entryId);
CREATE TRIGGER trigger40 AFTER INSERT ON hardlinkEntries  BEGIN    UPDATE entries      SET offset=NEW.fragmentOffset,          size  =NEW.fragmentSize      WHERE id=NEW.entryId;  END;
CREATE INDEX index41 ON specialEntries (storageId);
CREATE INDEX index42 ON specialEntries (entryId);
CREATE TRIGGER trigger43 AFTER INSERT ON specialEntries  BEGIN    UPDATE entries      SET offset=0,          size  =0      WHERE id=NEW.entryId;  END;
CREATE INDEX index44 ON history (jobUUID,created,type);
CREATE INDEX index45 ON history (created);
PRAGMA writable_schema=OFF;
COMMIT;
